/*
 * Decompiled with CFR 0.152.
 */
package sistema;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sic7.Principal;
import sistema.Database;
import sistema.cURL;

public class Util {
    public static String VERSAO_SIC7 = "20170716001";
    private static HashMap<String, String> config = new HashMap();
    private static Database database = null;
    public static String versaoSIC7Java = "20180918001";

    public static HashMap<String, Object> convertJson(String dados) {
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        try {
            JSONObject json = new JSONObject(dados);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                retorno.put(key, json.get(key).toString());
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retorno;
    }

    public static void file_put_contents(String filename, String texto) {
        try {
            String filenameTmp = filename + ".tmp";
            FileWriter arq = new FileWriter(filenameTmp);
            PrintWriter gravarArq = new PrintWriter(arq);
            gravarArq.printf(texto, new Object[0]);
            arq.close();
            File arquivo = new File(filenameTmp);
            arquivo.renameTo(new File(filename));
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String file_get_contents(String filename) {
        String texto = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while (br.ready()) {
                String linha = br.readLine();
                texto = texto + linha;
            }
            br.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
        return texto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURL(String surl, String pathname) {
        try {
            int len;
            URL url = new URL(surl);
            InputStream in = url.openStream();
            File file = new File(pathname);
            FileOutputStream os = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                for (int i = 0; i < len; ++i) {
                    os.write(buf[i]);
                }
            }
            os.flush();
            os.close();
            in.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String base64encode(String string) {
        return Base64.getEncoder().encodeToString(string.getBytes());
    }

    public static String base64decode(String encodedHello) {
        byte[] encodedHelloBytes = Base64.getDecoder().decode(encodedHello);
        String helloAgain = new String(encodedHelloBytes, StandardCharsets.UTF_8);
        return helloAgain;
    }

    public static String getNow() {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date date = new Date();
        return format.format(date);
    }

    public static String logCpuEnvironment() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.println("General information: ");
        pw.println("   Operating System: " + System.getProperty("os.name") + " - " + System.getProperty("sun.os.patch.level"));
        pw.println("   Java Version: " + System.getProperty("java.version") + " - " + System.getProperty("java.vendor"));
        long max = Runtime.getRuntime().maxMemory();
        int maxMega = (int)((float)max / 1048576.0f);
        pw.println("   Heap Space: " + maxMega + "MB");
        pw.println("   User name: " + System.getProperty("user.name"));
        pw.println("   Language: " + System.getProperty("user.language"));
        pw.println("   Country: " + System.getProperty("user.country"));
        return sw.toString();
    }

    public static void carregaConfig() {
        String value = Util.file_get_contents("config.txt");
        if (!value.equals("")) {
            value = value.substring(1, value.length() - 1);
            String[] keyValuePairs = value.split(",");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : keyValuePairs) {
                String[] entry = pair.split("=");
                if (entry.length > 1) {
                    map.put(entry[0].trim(), entry[1].trim());
                    continue;
                }
                map.put(entry[0].trim(), "");
            }
            config = map;
        } else {
            config.put("DATABASE", "");
            config.put("SIC7_KEY", "");
            config.put("id_impressora", "0");
            config.put("impressora", "zebra");
            config.put("ipBanco", "sic7.com.br");
            config.put("url", "http://sic7.com.br:2000/");
            config.put("porta", "3306");
            config.put("usuarioBanco", "root");
            config.put("senhaBanco", "SEM_SENHA");
            config.put("pathTefDialResp", "C://TEF_DIAL//Resp//");
            config.put("fileTefDialResp", "IntPos.001");
            config.put("urlIntegracao", "http://localhost/sic7_2/controller/sistema/integracao.controller.php");
            config.put("delay_ms", "2000");
            config.put("comandoImpressao", "");
            Util.salvaConfig();
        }
    }

    public static void salvaConfig() {
        Util.deletarArquivo("config.txt");
        Util.file_put_contents("config.txt", config.toString());
    }

    public static void setConfig(String config_name, String config_value) {
        config.put(config_name, config_value);
        Util.salvaConfig();
    }

    public static String getConfig(String config_name) {
        String ret = config.get(config_name);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public static HashMap<String, String> getConfig() {
        return config;
    }

    public static long timeDiff(Calendar data, Calendar data2) {
        try {
            long ini = data.getTimeInMillis();
            long fim = data2.getTimeInMillis();
            return fim - ini;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static Database getDatabase() {
        if (database == null) {
            database = new Database();
        }
        return database;
    }

    public static boolean desconectarDatabase() {
        if (database != null) {
            database.desconectar();
        }
        database = null;
        return true;
    }

    static Color hexToRgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public static String getHTML(String urlToRead) {
        try {
            String line;
            StringBuilder result = new StringBuilder();
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            rd.close();
            return result.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    static boolean convertBoolean(String b) {
        return b.equals("1") || b.equals("TRUE") || b.equals("true");
    }

    public static String lerArquivoTempo(String arquivo, int tempo) {
        String ret;
        block9: {
            ret = null;
            String CRLF = "\r\n";
            try {
                File f = new File(arquivo);
                for (int i = 0; i < tempo && !f.exists(); ++i) {
                    Thread.sleep(1000L);
                }
                if (!f.exists()) break block9;
                try (BufferedReader br = new BufferedReader(new FileReader(f));){
                    StringBuilder sb = new StringBuilder();
                    while (br.ready()) {
                        sb.append(br.readLine()).append(CRLF);
                    }
                    ret = sb.toString();
                }
            }
            catch (IOException | InterruptedException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                ret = null;
            }
        }
        return ret;
    }

    public static void deletarArquivo(String arquivo) {
        File f;
        if (Util.isFile(arquivo) && (f = new File(arquivo)).exists()) {
            f.delete();
        }
    }

    public static boolean isFile(String arquivo) {
        File f = new File(arquivo);
        return f.exists();
    }

    public static ArrayList<String> preg_math_all(String texto, String pattern) {
        ArrayList<String> retorno = new ArrayList<String>();
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(texto);
        while (m.find()) {
            String a = m.group(1);
            if (a.equals("")) continue;
            retorno.add(m.group(1));
        }
        return retorno;
    }

    public static String hexToDec(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char)Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    public static boolean postData(String url, HashMap<Object, String> post) {
        cURL curl = new cURL();
        Iterator<Object> interator = post.keySet().iterator();
        while (interator.hasNext()) {
            String key = interator.next().toString();
            url = url.indexOf("?") == -1 ? url + "?" : url + "&";
            try {
                url = url + key + "=" + URLEncoder.encode(post.get(key).toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
                Principal.setStatus(ex.getMessage());
                return false;
            }
        }
        String retorno = curl.exec(url);
        if (retorno.equals("")) {
            return false;
        }
        HashMap<String, Object> data = Util.convertJson(retorno);
        boolean status = false;
        if (data.size() > 0) {
            status = Util.convertBoolean(data.get("status").toString());
            String msg = data.get("msg").toString();
            try {
                msg = URLDecoder.decode(msg, "utf-8");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!msg.equals("")) {
                Principal.setStatus(msg);
            }
        } else {
            Principal.setStatus(retorno);
        }
        return status;
    }

    static String uniqueName() {
        SimpleDateFormat format = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
        Date date = new Date();
        return format.format(date);
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toString().toUpperCase().indexOf("MAC") > -1;
    }

    public static void msg(String mensagem, boolean b) {
        Util.msg(mensagem, b, -1);
    }

    public static void msg(String mensagem, boolean b, int tempo) {
        cURL curl = new cURL();
        String status = "1";
        String xtempo = String.valueOf(tempo);
        if (!b) {
            status = "0";
        }
        try {
            curl.exec("http://cloud.sic7.com.br:3000/notificacao?PK_usuarioDestino=1&DATABASE=sic7_manancial&status=" + status + "&tempo=" + xtempo + "&PK_dispositivo=0&msg=" + URLEncoder.encode(mensagem, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Document xmlToDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xml)));
        return doc;
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }
}

