/*
 * Decompiled with CFR 0.152.
 */
package sistema;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPrintPage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import sic7.Principal;

public class Impressora {
    private static PrintService impressora;

    public static List<String> retornaImressoras() {
        try {
            PrintService[] ps;
            ArrayList<String> listaImpressoras = new ArrayList<String>();
            DocFlavor.SERVICE_FORMATTED df = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            for (PrintService p : ps = PrintServiceLookup.lookupPrintServices(df, null)) {
                listaImpressoras.add(p.getName());
            }
            return listaImpressoras;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean detectaImpressoras(String impressoraSelecionada) {
        try {
            PrintService[] ps;
            DocFlavor.SERVICE_FORMATTED df = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            for (PrintService p : ps = PrintServiceLookup.lookupPrintServices(df, null)) {
                if (p.getName() == null || !p.getName().contains(impressoraSelecionada)) continue;
                impressora = p;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean imprime(String texto) {
        if (impressora == null) {
            Principal.setStatus("A impressora n\u00e3o foi encontrada.");
        } else {
            try {
                DocPrintJob dpj = impressora.createPrintJob();
                ByteArrayInputStream stream = new ByteArrayInputStream(texto.getBytes());
                DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                SimpleDoc doc = new SimpleDoc(stream, flavor, null);
                dpj.print(doc, null);
                return true;
            }
            catch (PrintException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void acionarGuilhotina() {
        this.imprime("\u001bm");
    }

    public static void listaImpressoras() {
        String msg = "";
        List<String> impressoras = Impressora.retornaImressoras();
        if (impressoras == null) {
            msg = msg + "\nImpressoras dispon\u00edveis: NULL";
            msg = msg + "\nNenhuma impressora encontrada";
        } else {
            msg = msg + "\nImpressoras dispon\u00edveis: [" + impressoras.size() + "]";
            for (int i = 0; i < impressoras.size(); ++i) {
                msg = msg + "\n" + impressoras.get(i);
            }
        }
        Principal.setStatus(msg);
    }

    public void printPdf(String nomeImpressora, String pathname, boolean delete) {
        this.printPdf(nomeImpressora, pathname, delete, "P");
    }

    public void printPdf(String nomeImpressora, String pathname, boolean delete, String orientation) {
        try {
            File f = null;
            RandomAccessFile fis = null;
            FileChannel fc = null;
            ByteBuffer bb = null;
            f = new File(pathname);
            if (!this.detectaImpressoras(nomeImpressora)) {
                String msg = "Impressora " + nomeImpressora + " N\u00c3O encontrada";
                List<String> impressoras = Impressora.retornaImressoras();
                msg = msg + "\nImpressoras dispon\u00edveis:";
                if (impressoras == null) {
                    msg = msg + "\nNenhuma impressora encontrada (NULL)";
                } else {
                    for (int i = 0; i < impressoras.size(); ++i) {
                        msg = msg + "\n" + impressoras.get(i);
                    }
                }
                Principal.setStatus(msg);
                f.delete();
                return;
            }
            Principal.setStatus("Enviando PDF para  " + nomeImpressora);
            fis = new RandomAccessFile(f, "rw");
            fc = fis.getChannel();
            bb = ByteBuffer.allocate((int)fc.size());
            fc.read(bb);
            PDFFile pdfFile = new PDFFile(bb);
            PDFPrintPage pages = new PDFPrintPage(pdfFile);
            PrinterJob pjob = PrinterJob.getPrinterJob();
            pjob.setPrintService(impressora);
            PageFormat pf = PrinterJob.getPrinterJob().defaultPage();
            Paper paper = new Paper();
            if (orientation.equals("L") || orientation.equals("l")) {
                pf.setOrientation(0);
                paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            } else {
                pf.setOrientation(1);
                paper.setImageableArea(0.0, 0.0, paper.getWidth() * 2.0, paper.getHeight());
            }
            pf.setPaper(paper);
            pjob.setJobName(f.getName());
            Book book = new Book();
            book.append((Printable)pages, pf, pdfFile.getNumPages());
            pjob.setPageable(book);
            pjob.print();
            Principal.setStatus("Documento impresso em " + nomeImpressora);
            try {
                fc.close();
                fis.close();
                if (delete) {
                    f.delete();
                }
            }
            catch (Exception e) {
                Principal.setStatus("Exception Impressora.java 165");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Principal.setStatus("Erro printPdf: " + e.getMessage());
        }
    }

    public void testeImpressao(String[] args) {
        try {
            DocFlavor.SERVICE_FORMATTED df = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            PrintService[] pservice = PrintServiceLookup.lookupPrintServices(df, null);
            System.out.println("Impressoras:");
            for (PrintService p : pservice) {
                System.out.println(p.getName());
            }
            for (PrintService printer : pservice) {
                if (!printer.getName().contains(args[1])) continue;
                System.out.println("\nEnviando impress\u00e3o para: " + printer.getName());
                DocPrintJob job = printer.createPrintJob();
                String commands = "";
                String CRLF = "\n";
                commands = "N" + CRLF + "R0,0" + CRLF + "ZT" + CRLF + "I8,0,001" + CRLF + "q800" + CRLF + "JY0000Kf00" + CRLF + "D8" + CRLF + "S3" + CRLF + "OD" + CRLF + "JB" + CRLF + "B70,91,0,1,2,4,80,B,\"01234567890\"" + CRLF + "Q293,0" + CRLF + "A50,30,0,1,1,1,N,\"Esta e a fonte 1\"" + CRLF + "A50,70,0,2,1,1,N,\"Esta e a fonte 2" + CRLF + "A50,110,0,3,1,1,N,\"Esta e a fonte 3\"" + CRLF + "A50,150,0,4,1,1,N,\"Esta e a fonte 4\"" + CRLF + "A50,200,0,5,1,1,R,\"ESTA E A FONTE 5\"" + CRLF + "" + CRLF + "P1,1" + CRLF + "" + CRLF;
                System.out.print("\ncommands:\n");
                System.out.println(commands);
                DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
                SimpleDoc doc = new SimpleDoc(commands.getBytes(), flavor, null);
                job.print(doc, null);
            }
        }
        catch (PrintException ex) {
            ex.printStackTrace();
        }
    }
}

