/*
 * Decompiled with CFR 0.152.
 */
package nfiscal;

import java.io.IOException;

public class Console {
    private static String readLine() {
        String tLinha = "";
        boolean tFim = false;
        while (!tFim) {
            try {
                int tCh = System.in.read();
                if (tCh < 0 || (char)tCh == '\n') {
                    tFim = true;
                    continue;
                }
                if ((char)tCh == '\r') continue;
                tLinha = tLinha + (char)tCh;
            }
            catch (IOException tExcept) {
                tLinha = null;
                tFim = true;
            }
        }
        return tLinha;
    }

    private static void printPrompt(String pPrompt) {
        System.out.print(pPrompt);
        System.out.flush();
    }

    private static byte ajustaByte(long pValor) {
        if (pValor < -128L) {
            return -128;
        }
        if (pValor > 127L) {
            return 127;
        }
        return (byte)pValor;
    }

    private static short ajustaShort(long pValor) {
        if (pValor < -32768L) {
            return Short.MIN_VALUE;
        }
        if (pValor > 32767L) {
            return Short.MAX_VALUE;
        }
        return (short)pValor;
    }

    private static int ajustaInt(long pValor) {
        if (pValor < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (pValor > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)pValor;
    }

    private static float ajustaFloat(double pValor) {
        if (pValor < (double)1.4E-45f) {
            return Float.MIN_VALUE;
        }
        if (pValor > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        return (float)pValor;
    }

    public static byte readByte(String pPrompt, long pValor) {
        while (true) {
            try {
                Console.printPrompt(pPrompt);
                String tLinha = Console.readLine().trim();
                if (tLinha.equals("")) {
                    return Console.ajustaByte(pValor);
                }
                return Byte.valueOf(tLinha);
            }
            catch (NumberFormatException tExcept) {
                System.out.println("Valor invalido para o tipo 'byte'");
                System.out.println("Digite novamente...");
                continue;
            }
            break;
        }
    }

    public static byte readByte(String pPrompt) {
        return Console.readByte(pPrompt, 0L);
    }

    public static byte readByte(long pVlr) {
        byte tVlr = Console.ajustaByte(pVlr);
        return Console.readByte("Entre com um valor do tipo 'byte' (" + tVlr + " default) : ", tVlr);
    }

    public static byte readByte() {
        return Console.readByte("Entre com um valor do tipo 'byte' (0 default) : ", 0L);
    }

    public static short readShort(String pPrompt, long pValor) {
        while (true) {
            try {
                Console.printPrompt(pPrompt);
                String tLinha = Console.readLine().trim();
                if (tLinha.equals("")) {
                    return Console.ajustaShort(pValor);
                }
                return Short.valueOf(tLinha);
            }
            catch (NumberFormatException tExcept) {
                System.out.println("Valor invalido para o tipo 'short'");
                System.out.println("Digite novamente...");
                continue;
            }
            break;
        }
    }

    public static short readShort(String pPrompt) {
        return Console.readShort(pPrompt, 0L);
    }

    public static short readShort(long pVlr) {
        short tVlr = Console.ajustaShort(pVlr);
        return Console.readShort("Entre com um valor do tipo 'short' (" + tVlr + " default) : ", tVlr);
    }

    public static short readShort() {
        return Console.readShort("Entre com um valor do tipo 'short' (0 default) : ", 0L);
    }

    public static int readInt(String pPrompt, long pValor) {
        while (true) {
            try {
                Console.printPrompt(pPrompt);
                String tLinha = Console.readLine().trim();
                if (tLinha.equals("")) {
                    return Console.ajustaInt(pValor);
                }
                return Integer.valueOf(tLinha);
            }
            catch (NumberFormatException tExcept) {
                System.out.println("Valor invalido para o tipo 'int'");
                System.out.println("Digite novamente...");
                continue;
            }
            break;
        }
    }

    public static int readInt(String pPrompt) {
        return Console.readInt(pPrompt, 0L);
    }

    public static int readInt(long pVlr) {
        int tVlr = Console.ajustaInt(pVlr);
        return Console.readInt("Entre com um valor do tipo 'int' (" + tVlr + " default) : ", tVlr);
    }

    public static int readInt() {
        return Console.readInt("Entre com um valor do tipo 'int' (0 default) : ", 0L);
    }

    public static long readLong(String pPrompt, long pValor) {
        while (true) {
            try {
                Console.printPrompt(pPrompt);
                String tLinha = Console.readLine().trim();
                if (tLinha.equals("")) {
                    return pValor;
                }
                return Long.valueOf(tLinha);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor invalido para o tipo 'long'");
                System.out.println("Digite novamente...");
                continue;
            }
            break;
        }
    }

    public static long readLong(String pPrompt) {
        return Console.readLong(pPrompt, 0L);
    }

    public static long readLong(long pVlr) {
        return Console.readLong("Entre com um valor do tipo 'long' (" + pVlr + " default) : ", pVlr);
    }

    public static long readLong() {
        return Console.readLong("Entre com um valor do tipo 'long' (0 default) : ", 0L);
    }

    public static float readFloat(String pPrompt, double pValor) {
        while (true) {
            try {
                Console.printPrompt(pPrompt);
                String tLinha = Console.readLine().trim();
                if (tLinha.equals("")) {
                    return Console.ajustaFloat(pValor);
                }
                return Float.valueOf(tLinha).floatValue();
            }
            catch (NumberFormatException e) {
                System.out.println("Valor invalido para o tipo 'float'");
                System.out.println("Digite novamente...");
                continue;
            }
            break;
        }
    }

    public static float readFloat(String pPrompt) {
        return Console.readFloat(pPrompt, 0.0);
    }

    public static float readFloat(double pVlr) {
        float tVlr = Console.ajustaFloat(pVlr);
        return Console.readFloat("Entre com um valor do tipo 'float' (" + tVlr + " default) : ", tVlr);
    }

    public static float readFloat() {
        return Console.readFloat("Entre com um valor do tipo 'float' (0 default) : ", 0.0);
    }

    public static double readDouble(String pPrompt, double pValor) {
        while (true) {
            try {
                Console.printPrompt(pPrompt);
                String tLinha = Console.readLine().trim();
                if (tLinha.equals("")) {
                    return pValor;
                }
                return Double.valueOf(tLinha);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor invalido para o tipo 'double'");
                System.out.println("Digite novamente...");
                continue;
            }
            break;
        }
    }

    public static double readDouble(String pPrompt) {
        return Console.readDouble(pPrompt, 0.0);
    }

    public static double readDouble(double pVlr) {
        return Console.readDouble("Entre com um valor do tipo 'double' (" + pVlr + " default) : ", pVlr);
    }

    public static double readDouble() {
        return Console.readDouble("Entre com um valor do tipo 'double' (0 default) : ", 0.0);
    }

    public static boolean readBoolean(String pPrompt, boolean pValor) {
        while (true) {
            Console.printPrompt(pPrompt);
            String tLinha = Console.readLine().trim();
            if (tLinha.equals("")) {
                return pValor;
            }
            if (tLinha.equalsIgnoreCase("true")) {
                return true;
            }
            if (tLinha.equalsIgnoreCase("false")) {
                return false;
            }
            System.out.println("Valor invalido para o tipo 'boolean' (true/false)");
            System.out.println("Digite novamente...");
        }
    }

    public static boolean readBoolean(String pPrompt) {
        return Console.readBoolean(pPrompt, false);
    }

    public static boolean readBoolean(boolean pVlr) {
        return Console.readBoolean("Entre com um valor do tipo 'boolean' (true/false) (" + pVlr + " default) : ", pVlr);
    }

    public static boolean readBoolean() {
        return Console.readBoolean("Entre com um valor do tipo 'boolean' (true/false) ('false' default) : ", false);
    }

    public static char readChar(String pPrompt, char pCh) {
        char tResult = pCh;
        boolean tFim = false;
        boolean tLido = false;
        Console.printPrompt(pPrompt);
        while (!tFim) {
            try {
                int tCh = System.in.read();
                if (tCh < 0 || (char)tCh == '\n') {
                    tFim = true;
                    continue;
                }
                if (tLido || (char)tCh == '\r') continue;
                tResult = (char)tCh;
                tLido = true;
            }
            catch (IOException tExcept) {
                tFim = true;
            }
        }
        return tResult;
    }

    public static char readChar(String pPrompt) {
        return Console.readChar(pPrompt, '\u0000');
    }

    public static char readChar(char pCh) {
        return Console.readChar("Entre com um valor do tipo 'char' (" + pCh + " default) : ", pCh);
    }

    public static char readChar() {
        return Console.readChar("Entre com um valor do tipo 'char' ('\u0000' default) : ", '\u0000');
    }

    public static String readString(String pPrompt, String pStr) {
        Console.printPrompt(pPrompt);
        String tLinha = Console.readLine();
        if (tLinha.equals("")) {
            return pStr;
        }
        return tLinha;
    }

    public static String readString(String pPrompt) {
        return Console.readString(pPrompt, "");
    }

    public static String readString() {
        return Console.readString("Entre com um valor do tipo 'String' (\"\" default) : ", "");
    }
}

