/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortEnumerator;
import javax.comm.CommPortOwnershipListener;
import javax.comm.CpoList;
import javax.comm.NoSuchPortException;
import javax.comm.OwnershipEventThread;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    String name;
    private int portType;
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    private boolean maskOwnershipEvents;
    OwnershipEventThread oeThread;
    CpoList cpoList = new CpoList();
    CommPortIdentifier next;
    private CommPort port;
    private CommDriver driver;
    static Object lock;
    static String propfilename;
    static CommPortIdentifier masterIdList;
    boolean owned;
    String owner;

    public static Enumeration getPortIdentifiers() {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkRead(propfilename);
        }
        return new CommPortEnumerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String portName) throws NoSuchPortException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkRead(propfilename);
        }
        CommPortIdentifier portId = null;
        Object object = lock;
        synchronized (object) {
            portId = masterIdList;
            while (portId != null && !portId.name.equals(portName)) {
                portId = portId.next;
            }
        }
        if (portId != null) {
            return portId;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort port) throws NoSuchPortException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkRead(propfilename);
        }
        CommPortIdentifier portId = null;
        Object object = lock;
        synchronized (object) {
            portId = masterIdList;
            while (portId != null && portId.port != port) {
                portId = portId.next;
            }
        }
        if (portId != null) {
            return portId;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPort(CommPort port, int portType) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkRead(propfilename);
        }
        CommPortIdentifier newentry = new CommPortIdentifier(port.getName(), port, portType, null);
        CommPortIdentifier cur = masterIdList;
        CommPortIdentifier prev = null;
        Object object = lock;
        synchronized (object) {
            while (cur != null) {
                prev = cur;
                cur = cur.next;
            }
            if (prev != null) {
                prev.next = newentry;
            } else {
                masterIdList = newentry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPortName(String portName, int portType, CommDriver driver) {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkRead(propfilename);
        }
        CommPortIdentifier newentry = new CommPortIdentifier(portName, null, portType, driver);
        CommPortIdentifier cur = masterIdList;
        CommPortIdentifier prev = null;
        Object object = lock;
        synchronized (object) {
            while (cur != null) {
                prev = cur;
                cur = cur.next;
            }
            if (prev != null) {
                prev.next = newentry;
            } else {
                masterIdList = newentry;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPortType() {
        return this.portType;
    }

    public synchronized CommPort open(String appname, int timeout) throws PortInUseException {
        if (this.owned) {
            this.maskOwnershipEvents = true;
            this.fireOwnershipEvent(3);
            this.maskOwnershipEvents = false;
            if (this.owned) {
                throw new PortInUseException(this.owner);
            }
        }
        this.port = this.driver.getCommPort(this.name, this.portType);
        if (this.port == null && this.port == null) {
            throw new PortInUseException("Unknown Windows Application");
        }
        this.owned = true;
        this.owner = appname;
        return this.port;
    }

    public String getCurrentOwner() {
        if (this.owned) {
            return this.owner;
        }
        return "";
    }

    public boolean isCurrentlyOwned() {
        return this.owned;
    }

    public void addPortOwnershipListener(CommPortOwnershipListener listener) {
        this.cpoList.add(listener);
        if (this.oeThread == null) {
            this.oeThread = new OwnershipEventThread(this);
            this.oeThread.start();
        }
    }

    public void removePortOwnershipListener(CommPortOwnershipListener lsnr) {
        this.cpoList.remove(lsnr);
    }

    void ownershipThreadWaiter() {
        int ret = 1;
        if (ret == 1) {
            this.maskOwnershipEvents = true;
            switch (ret) {
                case 0: {
                    this.fireOwnershipEvent(1);
                    break;
                }
                case 1: {
                    this.fireOwnershipEvent(2);
                    break;
                }
                case 2: {
                    this.fireOwnershipEvent(3);
                }
            }
            this.maskOwnershipEvents = false;
        }
    }

    synchronized void internalClosePort() {
        this.owned = false;
        this.owner = null;
        this.port = null;
        if (!this.maskOwnershipEvents) {
            this.fireOwnershipEvent(2);
        }
    }

    CommPortIdentifier(String name, CommPort port, int portType, CommDriver dr) {
        this.name = name;
        this.port = port;
        this.portType = portType;
        this.next = null;
        this.driver = dr;
    }

    void fireOwnershipEvent(int eventType) {
        CpoList clone = this.cpoList.clonelist();
        clone.fireOwnershipEvent(eventType);
    }

    private static String[] parsePropsFile(InputStream in) {
        Vector<String> strs = new Vector<String>();
        try {
            int b;
            byte[] ba = new byte[4096];
            int index = 0;
            boolean skip_to_eol = false;
            block7: while ((b = in.read()) != -1) {
                switch (b) {
                    case 9: 
                    case 32: {
                        continue block7;
                    }
                    case 10: 
                    case 13: {
                        String str;
                        if (index > 0) {
                            str = new String(ba, 0, 0, index);
                            strs.addElement(str);
                        }
                        index = 0;
                        skip_to_eol = false;
                        continue block7;
                    }
                    case 35: {
                        String str;
                        skip_to_eol = true;
                        if (index > 0) {
                            str = new String(ba, 0, 0, index);
                            strs.addElement(str);
                        }
                        index = 0;
                        continue block7;
                    }
                }
                if (skip_to_eol || index >= 4096) continue;
                ba[index++] = (byte)b;
            }
        }
        catch (Throwable ex) {
            System.err.println("Caught " + ex + " parsing prop file.");
        }
        if (strs.size() > 0) {
            String[] strarray = new String[strs.size()];
            for (int i = 0; i < strs.size(); ++i) {
                strarray[i] = (String)strs.elementAt(i);
            }
            return strarray;
        }
        return null;
    }

    public CommPort open(FileDescriptor fd) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    static {
        System.err.println("****************************************************************************");
        System.err.println("Java Communications API - Early Access");
        System.err.println("Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.");
        System.err.println("****************************************************************************");
        lock = new Object();
        String pdrivers = System.getProperty("javax.comm.properties");
        if (pdrivers != null) {
            System.err.println("Comm Drivers: " + pdrivers);
        }
        propfilename = System.getProperty("java.home") + File.separator + "lib" + File.separator + "javax.comm.properties";
        File propfile = new File(propfilename);
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(propfile));
            String[] drivers = CommPortIdentifier.parsePropsFile(fis);
            if (drivers != null) {
                for (int i = 0; i < drivers.length; ++i) {
                    if (!drivers[i].regionMatches(true, 0, "driver=", 0, 7)) continue;
                    String drivername = drivers[i].substring(7);
                    drivername.trim();
                    try {
                        CommDriver driver = (CommDriver)Class.forName(drivername).newInstance();
                        driver.initialize();
                        continue;
                    }
                    catch (Throwable th) {
                        System.err.println("Caught " + th + " while loading driver " + drivername);
                    }
                }
            }
        }
        catch (Throwable ex) {
            System.err.println(ex);
        }
    }
}

