/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.comm.CommPortIdentifier;

public class SerialDemo
extends Frame
implements ActionListener {
    final int HEIGHT = 450;
    final int WIDTH = 410;
    private MenuBar mb;
    private Menu fileMenu;
    private MenuItem openItem;
    private MenuItem saveItem;
    private MenuItem exitItem;
    private Button openButton;
    private Button closeButton;
    private Button breakButton;
    private Panel buttonPanel;
    private Panel messagePanel;
    private TextArea messageAreaOut;
    private TextArea messageAreaIn;
    private ConfigurationPanel configurationPanel;
    private SerialParameters parameters = new SerialParameters();
    private SerialConnection connection;
    private Properties props = null;

    public static void main2(String[] args) {
        if (args.length > 0 && (args[0].equals("-h") || args[0].equals("-help"))) {
            System.out.println("usage: java SerialDemo [configuration File]");
            System.exit(1);
        }
        SerialDemo serialDemo = new SerialDemo(args);
        serialDemo.setVisible(true);
        serialDemo.repaint();
    }

    public SerialDemo(String[] args) {
        super("Serial Demo");
        this.addWindowListener(new CloseHandler(this));
        this.mb = new MenuBar();
        this.fileMenu = new Menu("File");
        this.openItem = new MenuItem("Load");
        this.openItem.addActionListener(this);
        this.fileMenu.add(this.openItem);
        this.saveItem = new MenuItem("Save");
        this.saveItem.addActionListener(this);
        this.fileMenu.add(this.saveItem);
        this.exitItem = new MenuItem("Exit");
        this.exitItem.addActionListener(this);
        this.fileMenu.add(this.exitItem);
        this.mb.add(this.fileMenu);
        this.setMenuBar(this.mb);
        this.messagePanel = new Panel();
        this.messagePanel.setLayout(new GridLayout(2, 1));
        this.messageAreaOut = new TextArea();
        this.messagePanel.add(this.messageAreaOut);
        this.messageAreaIn = new TextArea();
        this.messageAreaIn.setEditable(false);
        this.messagePanel.add(this.messageAreaIn);
        this.add((Component)this.messagePanel, "Center");
        this.configurationPanel = new ConfigurationPanel(this);
        this.buttonPanel = new Panel();
        this.openButton = new Button("Open Port");
        this.openButton.addActionListener(this);
        this.buttonPanel.add(this.openButton);
        this.closeButton = new Button("Close Port");
        this.closeButton.addActionListener(this);
        this.closeButton.setEnabled(false);
        this.buttonPanel.add(this.closeButton);
        this.breakButton = new Button("Send Break");
        this.breakButton.addActionListener(this);
        this.breakButton.setEnabled(false);
        this.buttonPanel.add(this.breakButton);
        Panel southPanel = new Panel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints cons = new GridBagConstraints();
        southPanel.setLayout(gridBag);
        cons.gridwidth = 0;
        gridBag.setConstraints(this.configurationPanel, cons);
        cons.weightx = 1.0;
        southPanel.add(this.configurationPanel);
        gridBag.setConstraints(this.buttonPanel, cons);
        southPanel.add(this.buttonPanel);
        this.add((Component)southPanel, "South");
        this.parseArgs(args);
        this.connection = new SerialConnection(this, this.parameters, this.messageAreaOut, this.messageAreaIn);
        this.setConfigurationPanel();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - 205, screenSize.height / 2 - 225);
        this.setSize(410, 450);
    }

    public void setConfigurationPanel() {
        this.configurationPanel.setConfigurationPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileDialog fd;
        String cmd = e.getActionCommand();
        if (cmd.equals("Load")) {
            if (this.connection.isOpen()) {
                AlertDialog alertDialog = new AlertDialog(this, "Port Open!", "Configuration may not", "be loaded", "while a port is open.");
            } else {
                fd = new FileDialog((Frame)this, "Load Port Configuration", 0);
                fd.setVisible(true);
                String file = fd.getFile();
                if (file != null) {
                    String dir = fd.getDirectory();
                    File f = new File(dir + file);
                    try {
                        FileInputStream fis = new FileInputStream(f);
                        this.props = new Properties();
                        this.props.load(fis);
                        fis.close();
                    }
                    catch (FileNotFoundException e1) {
                        System.err.println(e1);
                    }
                    catch (IOException e2) {
                        System.err.println(e2);
                    }
                    this.loadParams();
                }
            }
        }
        if (cmd.equals("Save")) {
            this.configurationPanel.setParameters();
            fd = new FileDialog((Frame)this, "Save Port Configuration", 1);
            fd.setFile("serialdemo.properties");
            fd.setVisible(true);
            String fileName = fd.getFile();
            String directory = fd.getDirectory();
            if (fileName != null && directory != null) {
                this.writeFile(directory + fileName);
            }
        }
        if (cmd.equals("Exit")) {
            this.shutdown();
        }
        if (cmd.equals("Open Port")) {
            this.openButton.setEnabled(false);
            Cursor previousCursor = this.getCursor();
            this.setNewCursor(Cursor.getPredefinedCursor(3));
            this.configurationPanel.setParameters();
            try {
                this.connection.openConnection();
            }
            catch (SerialConnectionException e2) {
                AlertDialog ad = new AlertDialog(this, "Error Opening Port!", "Error opening port,", e2.getMessage() + ".", "Select new settings, try again.");
                this.openButton.setEnabled(true);
                this.setNewCursor(previousCursor);
                return;
            }
            this.portOpened();
            this.setNewCursor(previousCursor);
        }
        if (cmd.equals("Close Port")) {
            this.portClosed();
        }
        if (cmd.equals("Send Break")) {
            this.connection.sendBreak();
        }
    }

    public void portOpened() {
        this.openButton.setEnabled(false);
        this.closeButton.setEnabled(true);
        this.breakButton.setEnabled(true);
    }

    public void portClosed() {
        this.connection.closeConnection();
        this.openButton.setEnabled(true);
        this.closeButton.setEnabled(false);
        this.breakButton.setEnabled(false);
    }

    private void setNewCursor(Cursor c) {
        this.setCursor(c);
        this.messageAreaIn.setCursor(c);
        this.messageAreaOut.setCursor(c);
    }

    private void writeFile(String path) {
        FileOutputStream fileOut = null;
        Properties newProps = new Properties();
        newProps.put("portName", this.parameters.getPortName());
        newProps.put("baudRate", this.parameters.getBaudRateString());
        newProps.put("flowControlIn", this.parameters.getFlowControlInString());
        newProps.put("flowControlOut", this.parameters.getFlowControlOutString());
        newProps.put("parity", this.parameters.getParityString());
        newProps.put("databits", this.parameters.getDatabitsString());
        newProps.put("stopbits", this.parameters.getStopbitsString());
        try {
            fileOut = new FileOutputStream(path);
        }
        catch (IOException e) {
            System.out.println("Could not open file for writiing");
        }
        newProps.save(fileOut, "Serial Demo poperties");
        try {
            fileOut.close();
        }
        catch (IOException e) {
            System.out.println("Could not close file for writiing");
        }
    }

    private void shutdown() {
        this.connection.closeConnection();
        System.exit(1);
    }

    private void parseArgs(String[] args) {
        if (args.length < 1) {
            return;
        }
        File f = new File(args[0]);
        if (!f.exists()) {
            f = new File(System.getProperty("user.dir") + System.getProperty("path.separator") + args[0]);
        }
        if (f.exists()) {
            try {
                FileInputStream fis = new FileInputStream(f);
                this.props = new Properties();
                this.props.load(fis);
                fis.close();
                this.loadParams();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadParams() {
        this.parameters.setPortName(this.props.getProperty("portName"));
        this.parameters.setBaudRate(this.props.getProperty("baudRate"));
        this.parameters.setFlowControlIn(this.props.getProperty("flowControlIn"));
        this.parameters.setFlowControlOut(this.props.getProperty("flowControlOut"));
        this.parameters.setParity(this.props.getProperty("parity"));
        this.parameters.setDatabits(this.props.getProperty("databits"));
        this.parameters.setStopbits(this.props.getProperty("stopbits"));
        this.setConfigurationPanel();
    }

    class CloseHandler
    extends WindowAdapter {
        SerialDemo sd;

        public CloseHandler(SerialDemo sd) {
            this.sd = sd;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.sd.shutdown();
        }
    }

    class ConfigurationPanel
    extends Panel
    implements ItemListener {
        private Frame parent;
        private Label portNameLabel;
        private Choice portChoice;
        private Label baudLabel;
        private Choice baudChoice;
        private Label flowControlInLabel;
        private Choice flowChoiceIn;
        private Label flowControlOutLabel;
        private Choice flowChoiceOut;
        private Label databitsLabel;
        private Choice databitsChoice;
        private Label stopbitsLabel;
        private Choice stopbitsChoice;
        private Label parityLabel;
        private Choice parityChoice;

        public ConfigurationPanel(Frame parent) {
            this.parent = parent;
            this.setLayout(new GridLayout(4, 4));
            this.portNameLabel = new Label("Port Name:", 0);
            this.add(this.portNameLabel);
            this.portChoice = new Choice();
            this.portChoice.addItemListener(this);
            this.add(this.portChoice);
            this.listPortChoices();
            this.portChoice.select(SerialDemo.this.parameters.getPortName());
            this.baudLabel = new Label("Baud Rate:", 0);
            this.add(this.baudLabel);
            this.baudChoice = new Choice();
            this.baudChoice.addItem("300");
            this.baudChoice.addItem("2400");
            this.baudChoice.addItem("9600");
            this.baudChoice.addItem("14400");
            this.baudChoice.addItem("28800");
            this.baudChoice.addItem("38400");
            this.baudChoice.addItem("57600");
            this.baudChoice.addItem("152000");
            this.baudChoice.select(Integer.toString(SerialDemo.this.parameters.getBaudRate()));
            this.baudChoice.addItemListener(this);
            this.add(this.baudChoice);
            this.flowControlInLabel = new Label("Flow Control In:", 0);
            this.add(this.flowControlInLabel);
            this.flowChoiceIn = new Choice();
            this.flowChoiceIn.addItem("None");
            this.flowChoiceIn.addItem("Xon/Xoff In");
            this.flowChoiceIn.addItem("RTS/CTS In");
            this.flowChoiceIn.select(SerialDemo.this.parameters.getFlowControlInString());
            this.flowChoiceIn.addItemListener(this);
            this.add(this.flowChoiceIn);
            this.flowControlOutLabel = new Label("Flow Control Out:", 0);
            this.add(this.flowControlOutLabel);
            this.flowChoiceOut = new Choice();
            this.flowChoiceOut.addItem("None");
            this.flowChoiceOut.addItem("Xon/Xoff Out");
            this.flowChoiceOut.addItem("RTS/CTS Out");
            this.flowChoiceOut.select(SerialDemo.this.parameters.getFlowControlOutString());
            this.flowChoiceOut.addItemListener(this);
            this.add(this.flowChoiceOut);
            this.databitsLabel = new Label("Data Bits:", 0);
            this.add(this.databitsLabel);
            this.databitsChoice = new Choice();
            this.databitsChoice.addItem("5");
            this.databitsChoice.addItem("6");
            this.databitsChoice.addItem("7");
            this.databitsChoice.addItem("8");
            this.databitsChoice.select(SerialDemo.this.parameters.getDatabitsString());
            this.databitsChoice.addItemListener(this);
            this.add(this.databitsChoice);
            this.stopbitsLabel = new Label("Stop Bits:", 0);
            this.add(this.stopbitsLabel);
            this.stopbitsChoice = new Choice();
            this.stopbitsChoice.addItem("1");
            this.stopbitsChoice.addItem("1.5");
            this.stopbitsChoice.addItem("2");
            this.stopbitsChoice.select(SerialDemo.this.parameters.getStopbitsString());
            this.stopbitsChoice.addItemListener(this);
            this.add(this.stopbitsChoice);
            this.parityLabel = new Label("Parity:", 0);
            this.add(this.parityLabel);
            this.parityChoice = new Choice();
            this.parityChoice.addItem("None");
            this.parityChoice.addItem("Even");
            this.parityChoice.addItem("Odd");
            this.parityChoice.select("None");
            this.parityChoice.select(SerialDemo.this.parameters.getParityString());
            this.parityChoice.addItemListener(this);
            this.add(this.parityChoice);
        }

        public void setConfigurationPanel() {
            this.portChoice.select(SerialDemo.this.parameters.getPortName());
            this.baudChoice.select(SerialDemo.this.parameters.getBaudRateString());
            this.flowChoiceIn.select(SerialDemo.this.parameters.getFlowControlInString());
            this.flowChoiceOut.select(SerialDemo.this.parameters.getFlowControlOutString());
            this.databitsChoice.select(SerialDemo.this.parameters.getDatabitsString());
            this.stopbitsChoice.select(SerialDemo.this.parameters.getStopbitsString());
            this.parityChoice.select(SerialDemo.this.parameters.getParityString());
        }

        public void setParameters() {
            SerialDemo.this.parameters.setPortName(this.portChoice.getSelectedItem());
            SerialDemo.this.parameters.setBaudRate(this.baudChoice.getSelectedItem());
            SerialDemo.this.parameters.setFlowControlIn(this.flowChoiceIn.getSelectedItem());
            SerialDemo.this.parameters.setFlowControlOut(this.flowChoiceOut.getSelectedItem());
            SerialDemo.this.parameters.setDatabits(this.databitsChoice.getSelectedItem());
            SerialDemo.this.parameters.setStopbits(this.stopbitsChoice.getSelectedItem());
            SerialDemo.this.parameters.setParity(this.parityChoice.getSelectedItem());
        }

        void listPortChoices() {
            Enumeration en = CommPortIdentifier.getPortIdentifiers();
            while (en.hasMoreElements()) {
                CommPortIdentifier portId = (CommPortIdentifier)en.nextElement();
                if (portId.getPortType() != 1) continue;
                this.portChoice.addItem(portId.getName());
            }
            this.portChoice.select(SerialDemo.this.parameters.getPortName());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (SerialDemo.this.connection.isOpen()) {
                if (e.getItemSelectable() == this.portChoice) {
                    AlertDialog ad = new AlertDialog(this.parent, "Port Open!", "Port can not", "be changed", "while a port is open.");
                    this.setConfigurationPanel();
                    return;
                }
                this.setParameters();
                try {
                    SerialDemo.this.connection.setConnectionParameters();
                }
                catch (SerialConnectionException ex) {
                    AlertDialog ad = new AlertDialog(this.parent, "Unsupported Configuration!", "Configuration Parameter unsupported,", "select new value.", "Returning to previous configuration.");
                    this.setConfigurationPanel();
                }
            } else {
                this.setParameters();
            }
        }
    }
}

