/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SSLSocketChannel
implements ByteChannel {
    private ByteBuffer clientIn;
    private ByteBuffer clientOut;
    private ByteBuffer cTOs;
    private ByteBuffer sTOc;
    private ByteBuffer wbuf;
    private SocketChannel sc;
    private SSLEngineResult res;
    private SSLEngine sslEngine;
    private int SSL;

    public SSLSocketChannel(SocketChannel sc, SSLEngine sslEngine) throws IOException {
        this.sc = sc;
        this.sslEngine = sslEngine;
        this.SSL = 1;
        try {
            sslEngine.setEnableSessionCreation(true);
            SSLSession session = sslEngine.getSession();
            this.createBuffers(session);
            this.clientOut.clear();
            sc.write(this.wrap(this.clientOut));
            while (this.res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) {
                if (this.res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.sTOc.clear();
                    while (sc.read(this.sTOc) < 1) {
                        Thread.sleep(20L);
                    }
                    this.sTOc.flip();
                    this.unwrap(this.sTOc);
                    if (this.res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) continue;
                    this.clientOut.clear();
                    sc.write(this.wrap(this.clientOut));
                    continue;
                }
                if (this.res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    this.clientOut.clear();
                    sc.write(this.wrap(this.clientOut));
                    continue;
                }
                Thread.sleep(1000L);
            }
            this.clientIn.clear();
            this.clientIn.flip();
            this.SSL = 4;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.SSL = 0;
        }
    }

    private synchronized ByteBuffer wrap(ByteBuffer b) throws SSLException {
        this.cTOs.clear();
        this.res = this.sslEngine.wrap(b, this.cTOs);
        this.cTOs.flip();
        return this.cTOs;
    }

    private synchronized ByteBuffer unwrap(ByteBuffer b) throws SSLException {
        this.clientIn.clear();
        while (b.hasRemaining()) {
            this.res = this.sslEngine.unwrap(b, this.clientIn);
            if (this.res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                Runnable task;
                while ((task = this.sslEngine.getDelegatedTask()) != null) {
                    task.run();
                }
                continue;
            }
            if (this.res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                return this.clientIn;
            }
            if (this.res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            return this.clientIn;
        }
        return this.clientIn;
    }

    private void createBuffers(SSLSession session) {
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        this.clientIn = ByteBuffer.allocate(65536);
        this.clientOut = ByteBuffer.allocate(appBufferMax);
        this.wbuf = ByteBuffer.allocate(65536);
        this.cTOs = ByteBuffer.allocate(netBufferMax);
        this.sTOc = ByteBuffer.allocate(netBufferMax);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.SSL == 4) {
            return this.sc.write(this.wrap(src));
        }
        return this.sc.write(src);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int amount = 0;
        if (this.SSL == 4) {
            int i;
            int limit;
            if (this.clientIn.hasRemaining()) {
                int limit2 = Math.min(this.clientIn.remaining(), dst.remaining());
                for (int i2 = 0; i2 < limit2; ++i2) {
                    dst.put(this.clientIn.get());
                    ++amount;
                }
                return amount;
            }
            if (this.sTOc.hasRemaining()) {
                this.unwrap(this.sTOc);
                this.clientIn.flip();
                limit = Math.min(this.clientIn.limit(), dst.remaining());
                for (i = 0; i < limit; ++i) {
                    dst.put(this.clientIn.get());
                    ++amount;
                }
                if (this.res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this.sTOc.clear();
                    this.sTOc.flip();
                    return amount;
                }
            }
            if (!this.sTOc.hasRemaining()) {
                this.sTOc.clear();
            } else {
                this.sTOc.compact();
            }
            if (this.sc.read(this.sTOc) == -1) {
                this.sTOc.clear();
                this.sTOc.flip();
                return -1;
            }
            this.sTOc.flip();
            this.unwrap(this.sTOc);
            this.clientIn.flip();
            limit = Math.min(this.clientIn.limit(), dst.remaining());
            for (i = 0; i < limit; ++i) {
                dst.put(this.clientIn.get());
                ++amount;
            }
            return amount;
        }
        return this.sc.read(dst);
    }

    public boolean isConnected() {
        return this.sc.isConnected();
    }

    @Override
    public void close() throws IOException {
        if (this.SSL == 4) {
            this.sslEngine.closeOutbound();
            this.sslEngine.getSession().invalidate();
            this.clientOut.clear();
            this.sc.write(this.wrap(this.clientOut));
            this.sc.close();
        } else {
            this.sc.close();
        }
    }

    public SelectableChannel configureBlocking(boolean b) throws IOException {
        return this.sc.configureBlocking(b);
    }

    public boolean connect(SocketAddress remote) throws IOException {
        return this.sc.connect(remote);
    }

    public boolean finishConnect() throws IOException {
        return this.sc.finishConnect();
    }

    public Socket socket() {
        return this.sc.socket();
    }

    public boolean isInboundDone() {
        return this.sslEngine.isInboundDone();
    }

    @Override
    public boolean isOpen() {
        return this.sc.isOpen();
    }
}

