/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DFAssinaturaDigital {
    private static final String C14N_TRANSFORM_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private static final String[] ELEMENTOS_ASSINAVEIS = new String[]{"infEvento", "infCanc", "infNFe", "infInut", "infMDFe", "infCte"};
    private final DFConfig config;

    public DFAssinaturaDigital(DFConfig dFConfig) {
        this.config = dFConfig;
    }

    public boolean isValida(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nodeList.getLength() == 0) {
            throw new IllegalStateException("Nao foi encontrada a assinatura do XML.");
        }
        String string = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new DFKeySelector(), nodeList.item(0));
        for (String string2 : ELEMENTOS_ASSINAVEIS) {
            NodeList nodeList2 = document.getElementsByTagName(string2);
            if (nodeList2.getLength() <= 0) continue;
            dOMValidateContext.setIdAttributeNS((Element)nodeList2.item(0), null, "Id");
        }
        return xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext).validate(dOMValidateContext);
    }

    public String assinarDocumento(String string) throws Exception {
        return this.assinarDocumento(string, ELEMENTOS_ASSINAVEIS);
    }

    /*
     * Exception decompiling
     */
    public String assinarDocumento(String var1_1, String ... var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void assinarDocumento(Reader reader, Writer writer, String ... stringArray) throws Exception {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry();
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> arrayList = new ArrayList<Transform>(2);
        arrayList.add(xMLSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        arrayList.add(xMLSignatureFactory.newTransform(C14N_TRANSFORM_METHOD, (TransformParameterSpec)null));
        KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList((X509Certificate)privateKeyEntry.getCertificate()));
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(reader));
        for (String string : stringArray) {
            NodeList nodeList = document.getElementsByTagName(string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                String string2 = element.getAttribute("Id");
                element.setIdAttribute("Id", true);
                Reference reference = xMLSignatureFactory.newReference("#" + string2, xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), arrayList, null, null);
                SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod(C14N_TRANSFORM_METHOD, (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
                XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo);
                xMLSignature.sign(new DOMSignContext(privateKeyEntry.getPrivateKey(), element.getParentNode()));
            }
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(writer));
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry() throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        String string = this.config.getCertificadoAlias() != null ? this.config.getCertificadoAlias() : this.config.getCertificadoKeyStore().aliases().nextElement();
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(this.config.getCertificadoSenha().toCharArray());
        return (KeyStore.PrivateKeyEntry)this.config.getCertificadoKeyStore().getEntry(string, passwordProtection);
    }

    public String assinarString(String string) throws Exception {
        byte[] byArray = string.getBytes();
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(this.getPrivateKeyEntry().getPrivateKey());
        signature.update(byArray, 0, byArray.length);
        byte[] byArray2 = signature.sign();
        System.out.println(this.getPrivateKeyEntry().getPrivateKey().getFormat());
        return Base64.getEncoder().encodeToString(byArray2);
    }

    static class DFKeySelector
    extends KeySelector {
        DFKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
            for (XMLStructure xMLStructure : keyInfo.getContent()) {
                XMLStructure xMLStructure2 = xMLStructure;
                if (!(xMLStructure2 instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)xMLStructure2;
                for (Object obj : x509Data.getContent()) {
                    if (!(obj instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)obj;
                    if (!this.algEquals(algorithmMethod.getAlgorithm(), x509Certificate.getPublicKey().getAlgorithm())) continue;
                    return x509Certificate::getPublicKey;
                }
            }
            throw new KeySelectorException("Nao foi localizada a chave do certificado.");
        }

        private boolean algEquals(String string, String string2) {
            return string2.equalsIgnoreCase("DSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || string2.equalsIgnoreCase("RSA") && string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

