/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.transformers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.simpleframework.xml.transform.Transform;

public class DFLocalDateTransformer
implements Transform<LocalDate> {
    private static final DateTimeFormatter DATATIME_FORMATTER_YYYYMMDDXXX = DateTimeFormatter.ofPattern("yyyy-MM-ddXXX");
    private static final DateTimeFormatter DATATIME_FORMATTER_YYYYMMDDHHMMSSXXXX = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXXXX");
    private static final DateTimeFormatter DATETIME_FORMATTER_YYYYMMDD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATETIME_FORMATTER_DDMMYYYY = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter DATETIME_FORMATTER_DDMMYYYHHMMSS = DateTimeFormatter.ofPattern("dd/MM/yyyy' 'HH:mm:ss");

    public LocalDate read(String string) {
        try {
            return LocalDate.parse(string, DATETIME_FORMATTER_YYYYMMDD);
        }
        catch (Exception exception) {
            try {
                return LocalDate.from(DATATIME_FORMATTER_YYYYMMDDXXX.parse(string));
            }
            catch (Exception exception2) {
                try {
                    return LocalDate.from(DATETIME_FORMATTER_DDMMYYYY.parse(string));
                }
                catch (Exception exception3) {
                    try {
                        return LocalDate.from(DATETIME_FORMATTER_DDMMYYYHHMMSS.parse(string));
                    }
                    catch (Exception exception4) {
                        return LocalDate.from(DATATIME_FORMATTER_YYYYMMDDHHMMSSXXXX.parse(string));
                    }
                }
            }
        }
    }

    public String write(LocalDate localDate) {
        return DATETIME_FORMATTER_YYYYMMDD.format(localDate);
    }
}

