/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils;

import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class NFGeraHashCSRT {
    private final String chaveAcesso;
    private final NFeConfig config;

    public NFGeraHashCSRT(String string, NFeConfig nFeConfig) {
        this.chaveAcesso = string;
        this.config = nFeConfig;
    }

    public NFGeraHashCSRT(NFNota nFNota, NFeConfig nFeConfig) {
        this.chaveAcesso = nFNota.getInfo().getChaveAcesso();
        this.config = nFeConfig;
    }

    public String getHashCSRT() throws NoSuchAlgorithmException {
        return NFGeraHashCSRT.base64EncodeToString(this.config.getCSRT() + this.chaveAcesso);
    }

    public static String base64EncodeToString(String string) throws NoSuchAlgorithmException {
        return Base64.getEncoder().encodeToString(NFGeraHashCSRT.getSha1(string));
    }

    public static byte[] getSha1(String string) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA1").digest(string.getBytes());
    }

    public static String getStringSha1(String string) throws NoSuchAlgorithmException {
        return String.format("%040x", new BigInteger(1, NFGeraHashCSRT.getSha1(string)));
    }
}

