/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="infRespTec")
public class NFNotaInfoResponsavelTecnico
extends DFBase {
    @Element(name="CNPJ")
    private String cnpj;
    @Element(name="xContato")
    private String contatoNome;
    @Element(name="email")
    private String email;
    @Element(name="fone")
    private String telefone;
    @Element(name="idCSRT", required=false)
    private String idCSRT;
    @Element(name="hashCSRT", required=false)
    private String hashCSRT;

    public String getCnpj() {
        return this.cnpj;
    }

    public NFNotaInfoResponsavelTecnico setCnpj(String string) {
        StringValidador.cnpj(string);
        this.cnpj = string;
        return this;
    }

    public String getContatoNome() {
        return this.contatoNome;
    }

    public NFNotaInfoResponsavelTecnico setContatoNome(String string) {
        StringValidador.tamanho2ate60(string, "Responsavel tecnico");
        this.contatoNome = string;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public NFNotaInfoResponsavelTecnico setEmail(String string) {
        StringValidador.email(string, "Responsavel tecnico ");
        StringValidador.validaIntervalo(string, 6, 60, "Responsavel tecnico");
        this.email = string;
        return this;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public NFNotaInfoResponsavelTecnico setTelefone(String string) {
        StringValidador.telefone(string, "Responsavel tecnico");
        this.telefone = string;
        return this;
    }

    public String getIdCSRT() {
        return this.idCSRT;
    }

    public void setIdCSRT(String string) {
        StringValidador.exatamente2N(string, "Responsavel tecnico");
        this.idCSRT = string;
    }

    public String getHashCSRT() {
        return this.hashCSRT;
    }

    public void setHashCSRT(String string) {
        StringValidador.isBase64(string, "HASH CSRT em Responsavel tecnico");
        this.hashCSRT = string;
    }
}

