/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoMedicamento
extends DFBase {
    private static final long serialVersionUID = 3127772234811692432L;
    @Element(name="cProdANVISA")
    private String codigoProdutoAnvisa = null;
    @Element(name="vPMC")
    private String precoMaximoConsumidor = null;
    @Element(name="xMotivoIsencao", required=false)
    private String motivoIsencao;

    public String getCodigoProdutoAnvisa() {
        return this.codigoProdutoAnvisa;
    }

    public NFNotaInfoItemProdutoMedicamento setCodigoProdutoAnvisa(String string) {
        StringValidador.exatamente13(string, "C\u00f3digo produto anvisa");
        this.codigoProdutoAnvisa = string;
        return this;
    }

    public String getPrecoMaximoConsumidor() {
        return this.precoMaximoConsumidor;
    }

    public NFNotaInfoItemProdutoMedicamento setPrecoMaximoConsumidor(BigDecimal bigDecimal) {
        this.precoMaximoConsumidor = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Pre\u00e7o m\u00e1ximo consumidor");
        return this;
    }

    public String getMotivoIsencao() {
        return this.motivoIsencao;
    }

    public NFNotaInfoItemProdutoMedicamento setMotivoIsencao(String string) {
        StringValidador.validaTamanhoMaximo(string, 255, "Motivo da isen\u00e7\u00e3o da ANVISA");
        this.motivoIsencao = string;
        return this;
    }
}

