/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMSSN500
extends DFBase {
    private static final long serialVersionUID = 83636755742035633L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CSOSN")
    private NFNotaSituacaoOperacionalSimplesNacional situacaoOperacaoSN;
    @Element(name="vBCSTRet", required=false)
    private String valorBCICMSSTRetido;
    @Element(name="pST", required=false)
    private String percentualICMSSTRetido;
    @Element(name="vICMSSubstituto", required=false)
    private String valorICMSSubstituto;
    @Element(name="vICMSSTRet", required=false)
    private String valorICMSSTRetido;
    @Element(name="vBCFCPSTRet", required=false)
    private String valorBCFundoCombatePobrezaRetidoST;
    @Element(name="pFCPSTRet", required=false)
    private String percentualFundoCombatePobrezaRetidoST;
    @Element(name="vFCPSTRet", required=false)
    private String valorFundoCombatePobrezaRetidoST;
    @Element(name="pRedBCEfet", required=false)
    private String percentualReducaoBCEfetiva;
    @Element(name="vBCEfet", required=false)
    private String valorBCEfetiva;
    @Element(name="pICMSEfet", required=false)
    private String percentualAliquotaICMSEfetiva;
    @Element(name="vICMSEfet", required=false)
    private String valorICMSEfetivo;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional nFNotaSituacaoOperacionalSimplesNacional) {
        this.situacaoOperacaoSN = nFNotaSituacaoOperacionalSimplesNacional;
    }

    public void setValorBCICMSSTRetido(BigDecimal bigDecimal) {
        this.valorBCICMSSTRetido = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST Retido ICMSSN500");
    }

    public void setPercentualICMSSTRetido(BigDecimal bigDecimal) {
        this.percentualICMSSTRetido = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual ICMS ST Retido ICMSSN500");
    }

    public void setValorICMSSubstituto(BigDecimal bigDecimal) {
        this.valorICMSSubstituto = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Substituto ICMS60 Item");
    }

    public void setValorICMSSTRetido(BigDecimal bigDecimal) {
        this.valorICMSSTRetido = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST Retido ICMSSN500");
    }

    public void setValorBCFundoCombatePobrezaRetidoST(BigDecimal bigDecimal) {
        this.valorBCFundoCombatePobrezaRetidoST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor base calculo fundo combate pobreza retido ST");
    }

    public void setPercentualFundoCombatePobrezaRetidoST(BigDecimal bigDecimal) {
        if (bigDecimal.signum() <= 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobrezaRetidoST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual fundo combate pobreza retido ST");
    }

    public void setValorFundoCombatePobrezaRetidoST(BigDecimal bigDecimal) {
        this.valorFundoCombatePobrezaRetidoST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor fundo combate pobreza retido ST");
    }

    public void setPercentualReducaoBCEfetiva(BigDecimal bigDecimal) {
        this.percentualReducaoBCEfetiva = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual reducao BC efetiva");
    }

    public void setValorBCEfetiva(BigDecimal bigDecimal) {
        this.valorBCEfetiva = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC efetiva");
    }

    public void setPercentualAliquotaICMSEfetiva(BigDecimal bigDecimal) {
        this.percentualAliquotaICMSEfetiva = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual aliquota ICMS efetiva");
    }

    public void setValorICMSEfetivo(BigDecimal bigDecimal) {
        this.valorICMSEfetivo = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS efetivo");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaSituacaoOperacionalSimplesNacional getSituacaoOperacaoSN() {
        return this.situacaoOperacaoSN;
    }

    public String getValorBCICMSSTRetido() {
        return this.valorBCICMSSTRetido;
    }

    public String getPercentualICMSSTRetido() {
        return this.percentualICMSSTRetido;
    }

    public String getValorICMSSubstituto() {
        return this.valorICMSSubstituto;
    }

    public String getValorICMSSTRetido() {
        return this.valorICMSSTRetido;
    }

    public String getValorBCFundoCombatePobrezaRetidoST() {
        return this.valorBCFundoCombatePobrezaRetidoST;
    }

    public String getPercentualFundoCombatePobrezaRetidoST() {
        return this.percentualFundoCombatePobrezaRetidoST;
    }

    public String getValorFundoCombatePobrezaRetidoST() {
        return this.valorFundoCombatePobrezaRetidoST;
    }

    public String getPercentualReducaoBCEfetiva() {
        return this.percentualReducaoBCEfetiva;
    }

    public String getValorBCEfetiva() {
        return this.valorBCEfetiva;
    }

    public String getPercentualAliquotaICMSEfetiva() {
        return this.percentualAliquotaICMSEfetiva;
    }

    public String getValorICMSEfetivo() {
        return this.valorICMSEfetivo;
    }
}

