/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFEndereco;
import com.fincatto.documentofiscal.nfe400.classes.NFRegimeTributario;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;

public class NFNotaInfoEmitente
extends DFBase {
    private static final long serialVersionUID = -2236869565066526162L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="xFant", required=false)
    private String nomeFantasia;
    @Element(name="enderEmit")
    private NFEndereco endereco;
    @Element(name="IE")
    private String inscricaoEstadual;
    @Element(name="IEST", required=false)
    private String inscricaoEstadualSubstituicaoTributaria;
    @Element(name="IM", required=false)
    private String inscricaoMunicipal;
    @Element(name="CNAE", required=false)
    private String classificacaoNacionalAtividadesEconomicas;
    @Element(name="CRT")
    private NFRegimeTributario regimeTributario;

    public void setCnpj(String string) {
        if (this.cpf != null && string != null) {
            throw new IllegalStateException("Nao pode setar CNPJ caso CPF esteja setado");
        }
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public void setCpf(String string) {
        if (this.cnpj != null && string != null) {
            throw new IllegalStateException("Nao pode setar CPF caso CNPJ esteja setado");
        }
        StringValidador.cpf(string);
        this.cpf = string;
    }

    public void setRazaoSocial(String string) {
        StringValidador.tamanho60(string, "Razao Social Emitente");
        this.razaoSocial = string;
    }

    public void setNomeFantasia(String string) {
        StringValidador.tamanho60(string, "Nome Fantasia Emitente");
        this.nomeFantasia = string;
    }

    public void setEndereco(NFEndereco nFEndereco) {
        this.endereco = nFEndereco;
    }

    public void setInscricaoEstadual(String string) {
        StringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public void setInscricaoEstadualSubstituicaoTributaria(String string) {
        StringValidador.inscricaoEstadualSemIsencao(string);
        this.inscricaoEstadualSubstituicaoTributaria = string;
    }

    public void setInscricaoMunicipal(String string) {
        StringValidador.tamanho15(string, "IM Emitente");
        this.inscricaoMunicipal = string;
    }

    public void setClassificacaoNacionalAtividadesEconomicas(String string) {
        StringValidador.exatamente7N(string, "CNAE Emitente");
        this.classificacaoNacionalAtividadesEconomicas = string;
    }

    public void setRegimeTributario(NFRegimeTributario nFRegimeTributario) {
        this.regimeTributario = nFRegimeTributario;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getCpfj() {
        String string = "";
        if (StringUtils.isNotBlank((CharSequence)this.cpf)) {
            string = this.cpf;
        } else if (StringUtils.isNotBlank((CharSequence)this.cnpj)) {
            string = this.cnpj;
        }
        return string;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public NFEndereco getEndereco() {
        return this.endereco;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public String getInscricaoEstadualSubstituicaoTributaria() {
        return this.inscricaoEstadualSubstituicaoTributaria;
    }

    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    public String getClassificacaoNacionalAtividadesEconomicas() {
        return this.classificacaoNacionalAtividadesEconomicas;
    }

    public NFRegimeTributario getRegimeTributario() {
        return this.regimeTributario;
    }
}

