/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota.consulta;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="consSitNFe")
@Namespace(reference="http://www.portalfiscal.inf.br/nfe")
public class NFNotaConsulta
extends DFBase {
    private static final long serialVersionUID = 6261821910786634620L;
    @Attribute(name="versao")
    private String versao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="xServ")
    private String servico;
    @Element(name="chNFe")
    private String chave;

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = BigDecimalValidador.tamanho4Com2CasasDecimais(bigDecimal, "Versao Nota Consulta");
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public void setServico(String string) {
        this.servico = string;
    }

    public void setChave(String string) {
        StringValidador.exatamente44N(string, "Chave de Acesso Nota Consulta");
        this.chave = string;
    }

    public String getVersao() {
        return this.versao;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public String getServico() {
        return this.servico;
    }

    public String getChave() {
        return this.chave;
    }
}

