/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;

public class NFNotaInfoTransportador
extends DFBase {
    private static final long serialVersionUID = -6810459713123616929L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="xNome", required=false)
    private String razaoSocial;
    @Element(name="IE", required=false)
    private String inscricaoEstadual;
    @Element(name="xEnder", required=false)
    private String enderecoComplemento;
    @Element(name="xMun", required=false)
    private String nomeMunicipio;
    @Element(name="UF", required=false)
    private String uf;

    public void setEnderecoComplemento(String string) {
        this.enderecoComplemento = string;
    }

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("Nao pode ter CPF e CNPJ ao mesmo tempo");
        }
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("Nao pode ter CPF e CNPJ ao mesmo tempo");
        }
        StringValidador.cpf(string);
        this.cpf = string;
    }

    public void setRazaoSocial(String string) {
        StringValidador.tamanho60(string, "Razao Social Transportador");
        this.razaoSocial = string;
    }

    public void setInscricaoEstadual(String string) {
        StringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public void setNomeMunicipio(String string) {
        StringValidador.tamanho60(string, "Nome Municipio Transportador");
        this.nomeMunicipio = string;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public String getEnderecoComplemento() {
        return this.enderecoComplemento;
    }

    public String getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public String getUf() {
        return this.uf;
    }
}

