/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.IntegerValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoRetencaoICMSTransporte
extends DFBase {
    private static final long serialVersionUID = -5222569391852128441L;
    @Element(name="vServ")
    private String valorServico;
    @Element(name="vBCRet")
    private String bcRetencaoICMS;
    @Element(name="pICMSRet")
    private String aliquotaRetencao;
    @Element(name="vICMSRet")
    private String valorICMSRetido;
    @Element(name="CFOP")
    private Integer cfop;
    @Element(name="cMunFG")
    private String codigoMunicipioOcorrenciaFatoGeradorICMSTransporte;

    public void setValorServico(BigDecimal bigDecimal) {
        this.valorServico = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Servico Retencao ICMS Transporte");
    }

    public void setBcRetencaoICMS(BigDecimal bigDecimal) {
        this.bcRetencaoICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "BC Retencao ICMS Transporte");
    }

    public void setAliquotaRetencao(BigDecimal bigDecimal) {
        this.aliquotaRetencao = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota Retencao ICMS Transporte");
    }

    public void setValorICMSRetido(BigDecimal bigDecimal) {
        this.valorICMSRetido = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Retido Transporte");
    }

    public void setCfop(Integer n) {
        IntegerValidador.tamanho4(n, "CFOP Retencao ICMS Transporte");
        this.cfop = n;
    }

    public void setCodigoMunicipioOcorrenciaFatoGeradorICMSTransporte(String string) {
        StringValidador.exatamente7N(string, "Codigo Municipio Ocorrencia Fato Gerador ICMS Transporte");
        this.codigoMunicipioOcorrenciaFatoGeradorICMSTransporte = string;
    }

    public String getValorServico() {
        return this.valorServico;
    }

    public String getBcRetencaoICMS() {
        return this.bcRetencaoICMS;
    }

    public String getAliquotaRetencao() {
        return this.aliquotaRetencao;
    }

    public String getValorICMSRetido() {
        return this.valorICMSRetido;
    }

    public Integer getCfop() {
        return this.cfop;
    }

    public String getCodigoMunicipioOcorrenciaFatoGeradorICMSTransporte() {
        return this.codigoMunicipioOcorrenciaFatoGeradorICMSTransporte;
    }
}

