/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;

public class NFNotaInfoLocal
extends DFBase {
    private static final long serialVersionUID = -6618642990785758823L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="xLgr")
    private String logradouro;
    @Element(name="nro")
    private String numero;
    @Element(name="xCpl", required=false)
    private String complemento;
    @Element(name="xBairro")
    private String bairro;
    @Element(name="cMun")
    private String codigoMunicipio;
    @Element(name="xMun")
    private String nomeMunicipio;
    @Element(name="UF")
    private String uf;

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("Nao pode setar CNPJ por que o CPF foi setado");
        }
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("Nao pode setar CPF por que o CNPJ foi setado");
        }
        StringValidador.cpf(string);
        this.cpf = string;
    }

    public void setLogradouro(String string) {
        StringValidador.tamanho60(string, "Logradouro Local");
        this.logradouro = string;
    }

    public void setNumero(String string) {
        StringValidador.tamanho60(string, "Numero Local");
        this.numero = string;
    }

    public void setComplemento(String string) {
        StringValidador.tamanho60(string, "Complemento Local");
        this.complemento = string;
    }

    public void setBairro(String string) {
        StringValidador.tamanho2ate60(string, "Bairro Local");
        this.bairro = string;
    }

    public void setCodigoMunicipio(String string) {
        StringValidador.exatamente7(string, "Codigo Municipio Local");
        this.codigoMunicipio = string;
    }

    public void setNomeMunicipio(String string) {
        StringValidador.tamanho60(string, "Nome Municipio Local");
        this.nomeMunicipio = string;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getLogradouro() {
        return this.logradouro;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public String getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public String getUf() {
        return this.uf;
    }
}

