/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoCombustivelEncerrante
extends DFBase {
    private static final long serialVersionUID = 7349316876219960529L;
    @Element(name="nBico")
    private String numeroBico;
    @Element(name="nBomba", required=false)
    private String numeroBomba;
    @Element(name="nTanque")
    private String numeroTanque;
    @Element(name="vEncIni")
    private String valorEncerramentoInicial;
    @Element(name="vEncFin")
    private String valorEncerramentoFinal;

    public String getNumeroBico() {
        return this.numeroBico;
    }

    public String getNumeroBomba() {
        return this.numeroBomba;
    }

    public String getNumeroTanque() {
        return this.numeroTanque;
    }

    public String getValorEncerramentoInicial() {
        return this.valorEncerramentoInicial;
    }

    public String getValorEncerramentoFinal() {
        return this.valorEncerramentoFinal;
    }

    public void setNumeroBomba(String string) {
        StringValidador.tamanho3N(string, "Numero de identifica\u00e7\u00e3o da bomba ");
        this.numeroBomba = string;
    }

    public void setNumeroBico(String string) {
        StringValidador.tamanho3N(string, "Numero de identifica\u00e7\u00e3o do Bico ");
        this.numeroBico = string;
    }

    public void setNumeroTanque(String string) {
        StringValidador.tamanho3N(string, "Numero de identifica\u00e7\u00e3o do Tanque ");
        this.numeroTanque = string;
    }

    public void setValorEncerramentoInicial(BigDecimal bigDecimal) {
        this.valorEncerramentoInicial = BigDecimalValidador.tamanho11Com3CasasDecimais(bigDecimal, "Valor do Encerrante no inicio do abastecimento");
    }

    public void setValorEncerramentoFinal(BigDecimal bigDecimal) {
        this.valorEncerramentoFinal = BigDecimalValidador.tamanho11Com3CasasDecimais(bigDecimal, "Valor do Encerrante no final do abastecimento");
    }
}

