/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe310.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMSST
extends DFBase {
    private static final long serialVersionUID = -2354449482492846488L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="vBCSTRet")
    private String valorBCICMSSTRetidoUFRemetente;
    @Element(name="vICMSSTRet")
    private String valorICMSSTRetidoUFRemetente;
    @Element(name="vBCSTDest")
    private String valorBCICMSSTUFDestino;
    @Element(name="vICMSSTDest")
    private String valorICMSSTUFDestino;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setValorBCICMSSTRetidoUFRemetente(BigDecimal bigDecimal) {
        this.valorBCICMSSTRetidoUFRemetente = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST Retido UF Remetente");
    }

    public void setValorICMSSTRetidoUFRemetente(BigDecimal bigDecimal) {
        this.valorICMSSTRetidoUFRemetente = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST Retido UF Remetente");
    }

    public void setValorBCICMSSTUFDestino(BigDecimal bigDecimal) {
        this.valorBCICMSSTUFDestino = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST UF Destino");
    }

    public void setValorICMSSTUFDestino(BigDecimal bigDecimal) {
        this.valorICMSSTUFDestino = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST UF Destino");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getValorBCICMSSTRetidoUFRemetente() {
        return this.valorBCICMSSTRetidoUFRemetente;
    }

    public String getValorICMSSTRetidoUFRemetente() {
        return this.valorICMSSTRetidoUFRemetente;
    }

    public String getValorBCICMSSTUFDestino() {
        return this.valorBCICMSSTUFDestino;
    }

    public String getValorICMSSTUFDestino() {
        return this.valorICMSSTUFDestino;
    }
}

