/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe310.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMS10
extends DFBase {
    private static final long serialVersionUID = 3531314516853056385L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="modBC")
    private NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS;
    @Element(name="vBC")
    private String valorBaseCalculo;
    @Element(name="pICMS")
    private String percentualAliquota;
    @Element(name="vICMS")
    private String valorTributo;
    @Element(name="modBCST")
    private NFNotaInfoItemModalidadeBCICMSST modalidadeBCICMSST;
    @Element(name="pMVAST", required=false)
    private String percentualMargemValorICMSST;
    @Element(name="pRedBCST", required=false)
    private String percentualReducaoBCICMSST;
    @Element(name="vBCST")
    private String valorBCICMSST;
    @Element(name="pICMSST")
    private String percentualAliquotaImpostoICMSST;
    @Element(name="vICMSST")
    private String valorICMSST;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS nFNotaInfoItemModalidadeBCICMS) {
        this.modalidadeBCICMS = nFNotaInfoItemModalidadeBCICMS;
    }

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        this.valorBaseCalculo = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Base Calculo ICMS10 Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        this.percentualAliquota = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota ICMS10 Item");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo ICMS10 Item");
    }

    public void setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST nFNotaInfoItemModalidadeBCICMSST) {
        this.modalidadeBCICMSST = nFNotaInfoItemModalidadeBCICMSST;
    }

    public void setPercentualMargemValorICMSST(BigDecimal bigDecimal) {
        this.percentualMargemValorICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual MVA ICMS ST ICMS10 Item");
    }

    public void setPercentualReducaoBCICMSST(BigDecimal bigDecimal) {
        this.percentualReducaoBCICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS ST ICMS10 Item");
    }

    public void setValorBCICMSST(BigDecimal bigDecimal) {
        this.valorBCICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST ICMS10 Item");
    }

    public void setPercentualAliquotaImpostoICMSST(BigDecimal bigDecimal) {
        this.percentualAliquotaImpostoICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota Imposto ICMS ST ICMS10 Item");
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST ICMS10 Item");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public NFNotaInfoItemModalidadeBCICMS getModalidadeBCICMS() {
        return this.modalidadeBCICMS;
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }

    public NFNotaInfoItemModalidadeBCICMSST getModalidadeBCICMSST() {
        return this.modalidadeBCICMSST;
    }

    public String getPercentualMargemValorICMSST() {
        return this.percentualMargemValorICMSST;
    }

    public String getPercentualReducaoBCICMSST() {
        return this.percentualReducaoBCICMSST;
    }

    public String getValorBCICMSST() {
        return this.valorBCICMSST;
    }

    public String getPercentualAliquotaImpostoICMSST() {
        return this.percentualAliquotaImpostoICMSST;
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }
}

