/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;

public class NFNotaInfoDuplicata
extends DFBase {
    private static final long serialVersionUID = 4401957395684813604L;
    @Element(name="nDup", required=false)
    private String numeroDuplicata;
    @Element(name="dVenc", required=false)
    private LocalDate dataVencimento;
    @Element(name="vDup")
    private String valorDuplicata;

    public void setNumeroDuplicata(String string) {
        StringValidador.tamanho60(string, "Numero Duplicata");
        this.numeroDuplicata = string;
    }

    public void setDataVencimento(LocalDate localDate) {
        this.dataVencimento = localDate;
    }

    public void setValorDuplicata(BigDecimal bigDecimal) {
        this.valorDuplicata = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Duplicata");
    }

    public String getValorDuplicata() {
        return this.valorDuplicata;
    }

    public void setValorDuplicata(String string) {
        this.valorDuplicata = string;
    }

    public String getNumeroDuplicata() {
        return this.numeroDuplicata;
    }

    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }
}

