/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFEndereco;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFIndicadorIEDestinatario;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;

public class NFNotaInfoDestinatario
extends DFBase {
    private static final long serialVersionUID = 5245421887189198219L;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="idEstrangeiro", required=false)
    private String idEstrangeiro;
    @Element(name="xNome", required=false)
    private String razaoSocial;
    @Element(name="enderDest", required=false)
    private NFEndereco endereco;
    @Element(name="indIEDest")
    private NFIndicadorIEDestinatario indicadorIEDestinatario;
    @Element(name="IE", required=false)
    private String inscricaoEstadual;
    @Element(name="ISUF", required=false)
    private String inscricaoSuframa;
    @Element(name="IM", required=false)
    private String inscricaoMunicipal;
    @Element(name="email", required=false)
    private String email;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF esteja setado");
        }
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ esteja setado");
        }
        StringValidador.cpf(string);
        this.cpf = string;
    }

    public String getCpfj() {
        if (StringUtils.isNotBlank((CharSequence)this.cpf)) {
            return this.cpf;
        }
        if (StringUtils.isNotBlank((CharSequence)this.cnpj)) {
            return this.cnpj;
        }
        return this.idEstrangeiro;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setRazaoSocial(String string) {
        StringValidador.tamanho60(string, "Razao Social Destinatario");
        this.razaoSocial = string;
    }

    public void setEndereco(NFEndereco nFEndereco) {
        this.endereco = nFEndereco;
    }

    public void setInscricaoEstadual(String string) {
        StringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public void setInscricaoSuframa(String string) {
        StringValidador.tamanho8a9N(string, "Inscricao Suframa Destinatario");
        this.inscricaoSuframa = string;
    }

    public void setEmail(String string) {
        StringValidador.tamanho60(string, "Email Destinatario");
        this.email = string;
    }

    public void setIdEstrangeiro(String string) {
        if (!string.isEmpty()) {
            StringValidador.tamanho5a20(string, "ID Estrangeiro Destinatario");
        }
        this.idEstrangeiro = string;
    }

    public void setIndicadorIEDestinatario(NFIndicadorIEDestinatario nFIndicadorIEDestinatario) {
        this.indicadorIEDestinatario = nFIndicadorIEDestinatario;
    }

    public void setInscricaoMunicipal(String string) {
        StringValidador.tamanho15(string, "IM Destinatario");
        this.inscricaoMunicipal = string;
    }

    public String getIdEstrangeiro() {
        return this.idEstrangeiro;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public NFEndereco getEndereco() {
        return this.endereco;
    }

    public NFIndicadorIEDestinatario getIndicadorIEDestinatario() {
        return this.indicadorIEDestinatario;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public String getInscricaoSuframa() {
        return this.inscricaoSuframa;
    }

    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    public String getEmail() {
        return this.email;
    }
}

