/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.consultastatusservico.MDFeConsStatServ;
import com.fincatto.documentofiscal.mdfe3.classes.consultastatusservico.MDFeConsStatServRet;
import com.fincatto.documentofiscal.mdfe3.webservices.statusservico.MDFeStatusServicoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final MDFeConfig config;

    WSStatusConsulta(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    MDFeConsStatServRet consultaStatus(DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)WSStatusConsulta.gerarDadosConsulta(this.config).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsultaStatus(oMElement, dFUnidadeFederativa);
        this.getLogger().debug(oMElement2.toString());
        return (MDFeConsStatServRet)this.config.getPersister().read(MDFeConsStatServRet.class, oMElement2.toString());
    }

    private static MDFeConsStatServ gerarDadosConsulta(MDFeConfig mDFeConfig) {
        MDFeConsStatServ mDFeConsStatServ = new MDFeConsStatServ();
        mDFeConsStatServ.setAmbiente(mDFeConfig.getAmbiente());
        mDFeConsStatServ.setVersao("3.00");
        mDFeConsStatServ.setServico(NOME_SERVICO);
        return mDFeConsStatServ;
    }

    private OMElement efetuaConsultaStatus(OMElement oMElement, DFUnidadeFederativa dFUnidadeFederativa) throws RemoteException {
        MDFeStatusServicoStub.MdfeCabecMsg mdfeCabecMsg = new MDFeStatusServicoStub.MdfeCabecMsg();
        mdfeCabecMsg.setCUF(dFUnidadeFederativa.getCodigoIbge());
        mdfeCabecMsg.setVersaoDados("3.00");
        MDFeStatusServicoStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeStatusServicoStub.MdfeCabecMsgE();
        mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
        MDFeStatusServicoStub.MdfeDadosMsg mdfeDadosMsg = new MDFeStatusServicoStub.MdfeDadosMsg();
        mdfeDadosMsg.setExtraElement(oMElement);
        MDFAutorizador3 mDFAutorizador3 = MDFAutorizador3.valueOfCodigoUF(dFUnidadeFederativa);
        String string = mDFAutorizador3.getMDFeStatusServico(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico, autorizador " + mDFAutorizador3.name() + ", UF " + dFUnidadeFederativa.name());
        }
        MDFeStatusServicoStub.MdfeStatusServicoMDFResult mdfeStatusServicoMDFResult = new MDFeStatusServicoStub(string).mdfeStatusServicoMDF(mdfeDadosMsg, mdfeCabecMsgE);
        return mdfeStatusServicoMDFResult.getExtraElement();
    }
}

