/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLote;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLoteRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLoteRetornoDados;
import com.fincatto.documentofiscal.mdfe3.webservices.recepcao.MDFeRecepcaoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.XMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

class WSRecepcaoLote
implements DFLog {
    private static final String MDFE_ELEMENTO = "MDFe";
    private final MDFeConfig config;

    WSRecepcaoLote(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    public MDFEnvioLoteRetornoDados envioRecepcao(MDFEnvioLote mDFEnvioLote) throws Exception {
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(mDFEnvioLote.toString(), "infMDFe");
        MDFEnvioLote mDFEnvioLote2 = (MDFEnvioLote)this.config.getPersister().read(MDFEnvioLote.class, string);
        MDFEnvioLoteRetorno mDFEnvioLoteRetorno = this.comunicaLote(string);
        return new MDFEnvioLoteRetornoDados(mDFEnvioLoteRetorno, mDFEnvioLote2);
    }

    private MDFEnvioLoteRetorno comunicaLote(String string) throws Exception {
        System.setProperty("jdk.xml.maxOccurLimit", "10000");
        XMLValidador.validaLoteMDFe(string);
        OMElement oMElement = this.mdfeToOMElement(string);
        MDFeRecepcaoStub.MdfeDadosMsg mdfeDadosMsg = new MDFeRecepcaoStub.MdfeDadosMsg();
        mdfeDadosMsg.setExtraElement(oMElement);
        MDFeRecepcaoStub.MdfeCabecMsgE mdfeCabecMsgE = this.getCabecalhoSOAP();
        this.getLogger().debug(oMElement.toString());
        MDFAutorizador3 mDFAutorizador3 = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String string2 = mDFAutorizador3.getMDFeRecepcao(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Recepcao do MDFe, autorizador " + mDFAutorizador3.name() + ", UF " + this.config.getCUF().name());
        }
        MDFeRecepcaoStub.MdfeRecepcaoLoteResult mdfeRecepcaoLoteResult = new MDFeRecepcaoStub(string2).mdfeRecepcaoLote(mdfeDadosMsg, mdfeCabecMsgE);
        MDFEnvioLoteRetorno mDFEnvioLoteRetorno = (MDFEnvioLoteRetorno)this.config.getPersister().read(MDFEnvioLoteRetorno.class, mdfeRecepcaoLoteResult.getExtraElement().toString());
        this.getLogger().debug(mDFEnvioLoteRetorno.toString());
        return mDFEnvioLoteRetorno;
    }

    private MDFeRecepcaoStub.MdfeCabecMsgE getCabecalhoSOAP() {
        MDFeRecepcaoStub.MdfeCabecMsg mdfeCabecMsg = new MDFeRecepcaoStub.MdfeCabecMsg();
        mdfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        mdfeCabecMsg.setVersaoDados("3.00");
        MDFeRecepcaoStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeRecepcaoStub.MdfeCabecMsgE();
        mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
        return mdfeCabecMsgE;
    }

    private OMElement mdfeToOMElement(String string) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new StringReader(string));
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        Iterator iterator = oMElement.getChildrenWithLocalName(MDFE_ELEMENTO);
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (oMElement2 == null || !MDFE_ELEMENTO.equals(oMElement2.getLocalName())) continue;
            oMElement2.addAttribute("xmlns", "http://www.portalfiscal.inf.br/mdfe", null);
        }
        return oMElement;
    }
}

