/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.mdfe3.classes.consultaRecibo.MDFeConsultaRecibo;
import com.fincatto.documentofiscal.mdfe3.classes.consultaRecibo.MDFeConsultaReciboRetorno;
import com.fincatto.documentofiscal.mdfe3.webservices.retornorecepcao.MDFeRetRecepcaoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaRecibo
implements DFLog {
    private final MDFeConfig config;

    WSConsultaRecibo(MDFeConfig mDFeConfig) {
        this.config = mDFeConfig;
    }

    MDFeConsultaReciboRetorno consultaRecibo(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsultaRecibo(oMElement);
        this.getLogger().debug(oMElement2.toString());
        return (MDFeConsultaReciboRetorno)this.config.getPersister().read(MDFeConsultaReciboRetorno.class, oMElement2.toString());
    }

    private MDFeConsultaRecibo gerarDadosConsulta(String string) {
        MDFeConsultaRecibo mDFeConsultaRecibo = new MDFeConsultaRecibo();
        mDFeConsultaRecibo.setNumeroRecibo(string);
        mDFeConsultaRecibo.setAmbiente(this.config.getAmbiente());
        mDFeConsultaRecibo.setVersao("3.00");
        return mDFeConsultaRecibo;
    }

    private OMElement efetuaConsultaRecibo(OMElement oMElement) throws RemoteException {
        MDFeRetRecepcaoStub.MdfeCabecMsg mdfeCabecMsg = new MDFeRetRecepcaoStub.MdfeCabecMsg();
        mdfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        mdfeCabecMsg.setVersaoDados("3.00");
        MDFeRetRecepcaoStub.MdfeCabecMsgE mdfeCabecMsgE = new MDFeRetRecepcaoStub.MdfeCabecMsgE();
        mdfeCabecMsgE.setMdfeCabecMsg(mdfeCabecMsg);
        MDFeRetRecepcaoStub.MdfeDadosMsg mdfeDadosMsg = new MDFeRetRecepcaoStub.MdfeDadosMsg();
        mdfeDadosMsg.setExtraElement(oMElement);
        MDFAutorizador3 mDFAutorizador3 = MDFAutorizador3.valueOfCodigoUF(this.config.getCUF());
        String string = mDFAutorizador3.getMDFeRetornoRecepcao(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta Recibo, autorizador " + mDFAutorizador3.name() + ", UF " + this.config.getCUF().name());
        }
        return new MDFeRetRecepcaoStub(string).mdfeRetRecepcao(mdfeDadosMsg, mdfeCabecMsgE).getExtraElement();
    }
}

