/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class MDFInfoModalRodoviarioPedagioDisp
extends DFBase {
    private static final long serialVersionUID = 2437667548944630950L;
    @Element(name="CNPJForn")
    private String cnpjFornecedora;
    @Element(name="CNPJPg", required=false)
    private String cnpjPagadora;
    @Element(name="CPFPg")
    protected String cpfPagadora;
    @Element(name="nCompra")
    private String numeroComprovante;
    @Element(name="vValePed")
    private String valor;

    public String getCnpjFornecedora() {
        return this.cnpjFornecedora;
    }

    public void setCnpjFornecedora(String string) {
        StringValidador.cnpj(string);
        this.cnpjFornecedora = string;
    }

    public String getNumeroComprovante() {
        return this.numeroComprovante;
    }

    public void setNumeroComprovante(String string) {
        StringValidador.tamanho20N(string, "Numero do comprovante de compra");
        this.numeroComprovante = string;
    }

    public String getCnpjPagadora() {
        return this.cnpjPagadora;
    }

    public void setCnpjPagadora(String string) {
        if (this.cpfPagadora != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF esteja setado em PedagioDisp ");
        }
        StringValidador.cnpj(string);
        this.cnpjPagadora = string;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal bigDecimal) {
        this.valor = BigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor do pedagio");
    }

    public String getCpfPagadora() {
        return this.cpfPagadora;
    }

    public void setCpfPagadora(String string) {
        if (this.cnpjPagadora != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ esteja setado em PedagioDisp ");
        }
        StringValidador.cpf(string);
        this.cpfPagadora = string;
    }
}

