/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.nota.consulta.CTeNotaConsulta;
import com.fincatto.documentofiscal.cte300.classes.nota.consulta.CTeNotaConsultaRetorno;
import com.fincatto.documentofiscal.cte300.parsers.CTChaveParser;
import com.fincatto.documentofiscal.cte300.webservices.consulta.CteConsultaStub;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private static final String VERSAO_SERVICO = "3.00";
    private final CTeConfig config;

    WSNotaConsulta(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    public CTeNotaConsultaRetorno consultaNota(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement, string);
        this.getLogger().debug(oMElement2.toString());
        CTeNotaConsultaRetorno cTeNotaConsultaRetorno = (CTeNotaConsultaRetorno)this.config.getPersister().read(CTeNotaConsultaRetorno.class, oMElement2.toString());
        this.getLogger().debug(cTeNotaConsultaRetorno.toString());
        return cTeNotaConsultaRetorno;
    }

    private OMElement efetuaConsulta(OMElement oMElement, String string) throws Exception {
        CTChaveParser cTChaveParser = new CTChaveParser(string);
        CteConsultaStub.CteCabecMsg cteCabecMsg = new CteConsultaStub.CteCabecMsg();
        cteCabecMsg.setCUF(cTChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        cteCabecMsg.setVersaoDados(VERSAO_SERVICO);
        CteConsultaStub.CteCabecMsgE cteCabecMsgE = new CteConsultaStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        CteConsultaStub.CteDadosMsg cteDadosMsg = new CteConsultaStub.CteDadosMsg();
        cteDadosMsg.setExtraElement(oMElement);
        this.getLogger().debug(cteCabecMsg.toString());
        CTAutorizador31 cTAutorizador31 = CTAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string2 = cTAutorizador31.getCteConsultaProtocolo(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Consulta, autorizador " + cTAutorizador31.name() + ", UF " + this.config.getCUF().name());
        }
        this.getLogger().debug(string2);
        CteConsultaStub.CteConsultaCTResult cteConsultaCTResult = new CteConsultaStub(string2).cteConsultaCT(cteDadosMsg, cteCabecMsgE);
        return cteConsultaCTResult.getExtraElement();
    }

    private CTeNotaConsulta gerarDadosConsulta(String string) {
        CTeNotaConsulta cTeNotaConsulta = new CTeNotaConsulta();
        cTeNotaConsulta.setAmbiente(this.config.getAmbiente());
        cTeNotaConsulta.setChave(string);
        cTeNotaConsulta.setServico(NOME_SERVICO);
        cTeNotaConsulta.setVersao(new BigDecimal(VERSAO_SERVICO));
        return cTeNotaConsulta;
    }
}

