/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeDetalhamentoEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeEnviaEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeInfoEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeProtocoloEventoCancelamento;
import com.fincatto.documentofiscal.cte300.classes.evento.cancelamento.CTeRetornoCancelamento;
import com.fincatto.documentofiscal.cte300.parsers.CTChaveParser;
import com.fincatto.documentofiscal.cte300.webservices.recepcaoevento.RecepcaoEventoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSCancelamento
implements DFLog {
    private static final String DESCRICAO_EVENTO = "Cancelamento";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_CANCELAMENTO = "110111";
    private final CTeConfig config;

    WSCancelamento(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    CTeRetornoCancelamento cancelaNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaCancelamento(string2, string);
        return (CTeRetornoCancelamento)this.config.getPersister().read(CTeRetornoCancelamento.class, oMElement.toString());
    }

    CTeRetornoCancelamento cancelaNota(String string, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosCancelamento(string, string2, string3).toString();
        String string5 = new DFAssinaturaDigital(this.config).assinarDocumento(string4);
        OMElement oMElement = this.efetuaCancelamento(string5, string);
        return (CTeRetornoCancelamento)this.config.getPersister().read(CTeRetornoCancelamento.class, oMElement.toString());
    }

    private OMElement efetuaCancelamento(String string, String string2) throws Exception {
        CTChaveParser cTChaveParser = new CTChaveParser(string2);
        RecepcaoEventoStub.CteCabecMsg cteCabecMsg = new RecepcaoEventoStub.CteCabecMsg();
        cteCabecMsg.setCUF(cTChaveParser.getNFUnidadeFederativa().getCodigoIbge());
        cteCabecMsg.setVersaoDados(BigDecimalValidador.tamanho5Com2CasasDecimais(VERSAO_LEIAUTE, "Versao do Evento"));
        RecepcaoEventoStub.CteCabecMsgE cteCabecMsgE = new RecepcaoEventoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        RecepcaoEventoStub.CteDadosMsg cteDadosMsg = new RecepcaoEventoStub.CteDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        cteDadosMsg.setExtraElement(oMElement);
        CTAutorizador31 cTAutorizador31 = CTAutorizador31.valueOfChaveAcesso(string2);
        String string3 = cTAutorizador31.getRecepcaoEvento(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + cTChaveParser.getModelo().name() + ", autorizador " + cTAutorizador31.name());
        }
        RecepcaoEventoStub.CteRecepcaoEventoResult cteRecepcaoEventoResult = new RecepcaoEventoStub(string3).cteRecepcaoEvento(cteDadosMsg, cteCabecMsgE);
        OMElement oMElement2 = cteRecepcaoEventoResult.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private CTeProtocoloEventoCancelamento gerarDadosCancelamento(String string, String string2, String string3) {
        CTChaveParser cTChaveParser = new CTChaveParser(string);
        CTeEnviaEventoCancelamento cTeEnviaEventoCancelamento = new CTeEnviaEventoCancelamento();
        cTeEnviaEventoCancelamento.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoCancelamento.setJustificativa(string3.trim());
        cTeEnviaEventoCancelamento.setProtocoloAutorizacao(string2);
        CTeDetalhamentoEventoCancelamento cTeDetalhamentoEventoCancelamento = new CTeDetalhamentoEventoCancelamento();
        cTeDetalhamentoEventoCancelamento.setVersaoEvento(VERSAO_LEIAUTE);
        cTeDetalhamentoEventoCancelamento.setEventoCancelamento(cTeEnviaEventoCancelamento);
        CTeInfoEventoCancelamento cTeInfoEventoCancelamento = new CTeInfoEventoCancelamento();
        cTeInfoEventoCancelamento.setAmbiente(this.config.getAmbiente());
        cTeInfoEventoCancelamento.setChave(string);
        cTeInfoEventoCancelamento.setCnpj(cTChaveParser.getCnpjEmitente());
        cTeInfoEventoCancelamento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        cTeInfoEventoCancelamento.setId(String.format("ID%s%s0%s", EVENTO_CANCELAMENTO, string, "1"));
        cTeInfoEventoCancelamento.setNumeroSequencialEvento(1);
        cTeInfoEventoCancelamento.setOrgao(cTChaveParser.getNFUnidadeFederativa());
        cTeInfoEventoCancelamento.setCodigoEvento(EVENTO_CANCELAMENTO);
        cTeInfoEventoCancelamento.setCancelamento(cTeDetalhamentoEventoCancelamento);
        CTeEventoCancelamento cTeEventoCancelamento = new CTeEventoCancelamento();
        cTeEventoCancelamento.setInfoEvento(cTeInfoEventoCancelamento);
        cTeEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        CTeProtocoloEventoCancelamento cTeProtocoloEventoCancelamento = new CTeProtocoloEventoCancelamento();
        cTeProtocoloEventoCancelamento.setVersao(VERSAO_LEIAUTE);
        cTeProtocoloEventoCancelamento.setEvento(cTeEventoCancelamento);
        return cTeProtocoloEventoCancelamento;
    }
}

