/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infCarga")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoCarga
extends DFBase {
    private static final long serialVersionUID = -2031819416191957758L;
    @Element(name="vCarga")
    private String valorTotalCarga = null;
    @Element(name="proPred")
    private String descricaoProdutoPredominante = null;
    @Element(name="xOutCat", required=false)
    private String descricaoOutrasCaracteristicas = null;
    @ElementList(name="infQ", inline=true)
    private List<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> informacoesQuantidadeCarga = null;
    @Element(name="vCargaAverb", required=false)
    private String valorAverbacao = null;

    public String getValorTotalCarga() {
        return this.valorTotalCarga;
    }

    public void setValorTotalCarga(BigDecimal bigDecimal) {
        this.valorTotalCarga = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor total da carga");
    }

    public String getDescricaoProdutoPredominante() {
        return this.descricaoProdutoPredominante;
    }

    public void setDescricaoProdutoPredominante(String string) {
        StringValidador.tamanho60(string, "Produto predominante");
        this.descricaoProdutoPredominante = string;
    }

    public String getDescricaoOutrasCaracteristicas() {
        return this.descricaoOutrasCaracteristicas;
    }

    public void setDescricaoOutrasCaracteristicas(String string) {
        StringValidador.tamanho30(string, "Outras caracter\u00edsticas da carga");
        this.descricaoOutrasCaracteristicas = string;
    }

    public List<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> getInformacoesQuantidadeCarga() {
        return this.informacoesQuantidadeCarga;
    }

    public void setInformacoesQuantidadeCarga(List<CTeNotaInfoCTeNormalInfoCargaInformacoesQuantidadeCarga> list) {
        this.informacoesQuantidadeCarga = list;
    }

    public String getValorAverbacao() {
        return this.valorAverbacao;
    }

    public void setValorAverbacao(BigDecimal bigDecimal) {
        this.valorAverbacao = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Carga para efeito de averba\u00e7\u00e3o");
    }
}

