/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.validadores;

import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class XMLValidador {
    private static boolean valida(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = XMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_008i2/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLote(String string) throws Exception {
        return XMLValidador.valida(string, "enviNFe_v3.10.xsd");
    }

    public static boolean validaNota(String string) throws Exception {
        return XMLValidador.valida(string, "nfe_v3.10.xsd");
    }

    private static boolean valida400(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = XMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_009_V4_00_NT_2018_005_v1.20/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLote400(String string) throws Exception {
        return XMLValidador.valida400(string, "enviNFe_v4.00.xsd");
    }

    private static boolean validaMDF(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = XMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_MDFe_300a15072019/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLoteMDFe(String string) throws Exception {
        return XMLValidador.validaMDF(string, "enviMDFe_v3.00.xsd");
    }

    public static boolean validaMDFe(String string) throws Exception {
        return XMLValidador.validaMDF(string, "mdfe_v3.00.xsd");
    }

    private static boolean validaCTe(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = XMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_CTe_300_NT2018.002/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaLoteCTe(String string) throws Exception {
        return XMLValidador.validaCTe(string, "enviCTe_v3.00.xsd");
    }

    public static boolean validaNotaCte(String string) throws Exception {
        return XMLValidador.validaCTe(string, "cte_v3.00.xsd");
    }

    private static boolean validaDfe(String string, String string2) throws IOException, SAXException, URISyntaxException {
        URL uRL = XMLValidador.class.getClassLoader().getResource(String.format("schemas/PL_NFeDistDFe_102/%s", string2));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(uRL.toURI().toString()));
        schema.newValidator().validate(new StreamSource(new StringReader(string)));
        return true;
    }

    public static boolean validaConsultaDfe(String string) throws Exception {
        return XMLValidador.validaDfe(string, "distDFeInt_v1.01.xsd");
    }
}

