/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class DFSocketFactory
implements ProtocolSocketFactory {
    private final DFConfig config;
    private final SSLContext sslContext;

    public DFSocketFactory(DFConfig dFConfig) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        this.config = dFConfig;
        this.sslContext = this.createSSLContext(dFConfig);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException {
        Socket socket = this.sslContext.getSocketFactory().createSocket();
        ((SSLSocket)socket).setEnabledProtocols(this.config.getSSLProtocolos());
        socket.bind(new InetSocketAddress(inetAddress, n2));
        socket.connect(new InetSocketAddress(string, n), 60000);
        return socket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n) throws IOException {
        return this.sslContext.getSocketFactory().createSocket(string, n);
    }

    private SSLContext createSSLContext(DFConfig dFConfig) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        KeyManager[] keyManagerArray = this.createKeyManagers(dFConfig);
        TrustManager[] trustManagerArray = this.createTrustManagers(dFConfig);
        SSLContext sSLContext = SSLContext.getInstance(dFConfig.getSSLProtocolos()[0]);
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        return sSLContext;
    }

    private KeyManager[] createKeyManagers(DFConfig dFConfig) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        String string = DFSocketFactory.getAlias(dFConfig.getCertificadoKeyStore());
        X509Certificate x509Certificate = (X509Certificate)dFConfig.getCertificadoKeyStore().getCertificate(string);
        PrivateKey privateKey = (PrivateKey)dFConfig.getCertificadoKeyStore().getKey(string, dFConfig.getCertificadoSenha().toCharArray());
        return new KeyManager[]{new DFKeyManager(x509Certificate, privateKey)};
    }

    private TrustManager[] createTrustManagers(DFConfig dFConfig) throws KeyStoreException, NoSuchAlgorithmException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(dFConfig.getCadeiaCertificadosKeyStore());
        return trustManagerFactory.getTrustManagers();
    }

    private static String getAlias(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            return string;
        }
        throw new KeyStoreException("Nenhum alias encontrado no certificado");
    }

    static class DFKeyManager
    implements X509KeyManager {
        private final X509Certificate certificate;
        private final PrivateKey privateKey;

        DFKeyManager(X509Certificate x509Certificate, PrivateKey privateKey) {
            this.certificate = x509Certificate;
            this.privateKey = privateKey;
        }

        @Override
        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            return this.certificate.getIssuerDN().getName();
        }

        @Override
        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return new X509Certificate[]{this.certificate};
        }

        @Override
        public String[] getClientAliases(String string, Principal[] principalArray) {
            return new String[]{this.certificate.getIssuerDN().getName()};
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.privateKey;
        }

        @Override
        public String[] getServerAliases(String string, Principal[] principalArray) {
            return null;
        }
    }
}

