/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.mdfe3.classes.MDFAutorizador3;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.net.URI;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public abstract class DFCadeiaCertificados
implements DFLog {
    private static final int PORT = 443;
    private static final String PROTOCOL = "TLSv1.2";

    public static byte[] geraCadeiaCertificados(DFAmbiente dFAmbiente, String string) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, string.toCharArray());
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String string2;
            String string3;
            String string4;
            for (NFAutorizador31 nFAutorizador31 : NFAutorizador31.values()) {
                string4 = nFAutorizador31.getNfeStatusServico(dFAmbiente);
                if (StringUtils.isNotBlank((CharSequence)string4)) {
                    string3 = new URI(string4).getHost();
                    DFCadeiaCertificados.get(keyStore, string3);
                }
                if (!StringUtils.isNotBlank((CharSequence)(string3 = nFAutorizador31.getNfceStatusServico(dFAmbiente)))) continue;
                string2 = new URI(string3).getHost();
                DFCadeiaCertificados.get(keyStore, string2);
            }
            for (NFAutorizador400 nFAutorizador400 : NFAutorizador400.values()) {
                string4 = nFAutorizador400.getNfeStatusServico(dFAmbiente);
                if (StringUtils.isNotBlank((CharSequence)string4)) {
                    string3 = new URI(string4).getHost();
                    DFCadeiaCertificados.get(keyStore, string3);
                }
                if (!StringUtils.isNotBlank((CharSequence)(string3 = nFAutorizador400.getNfceStatusServico(dFAmbiente)))) continue;
                string2 = new URI(string3).getHost();
                DFCadeiaCertificados.get(keyStore, string2);
            }
            for (MDFAutorizador3 mDFAutorizador3 : MDFAutorizador3.values()) {
                string4 = mDFAutorizador3.getMDFeStatusServico(dFAmbiente);
                if (!StringUtils.isNotBlank((CharSequence)string4)) continue;
                string3 = new URI(string4).getHost();
                DFCadeiaCertificados.get(keyStore, string3);
            }
            for (CTAutorizador31 cTAutorizador31 : CTAutorizador31.values()) {
                string4 = cTAutorizador31.getCteStatusServico(dFAmbiente);
                if (!StringUtils.isNotBlank((CharSequence)string4)) continue;
                string3 = new URI(string4).getHost();
                DFCadeiaCertificados.get(keyStore, string3);
            }
            keyStore.store(byteArrayOutputStream, string.toCharArray());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private static void get(KeyStore keyStore, String string) throws Exception {
        Object object;
        Object object2;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        SavingTrustManager savingTrustManager = new SavingTrustManager(x509TrustManager);
        SSLContext sSLContext = SSLContext.getInstance(PROTOCOL);
        sSLContext.init(null, new TrustManager[]{savingTrustManager}, null);
        DFLog.getLogger(DFCadeiaCertificados.class).debug("Abrindo conexao para o servidor: {}:{}", (Object)string, (Object)443);
        try {
            object2 = (SSLSocket)sSLContext.getSocketFactory().createSocket(string, 443);
            object = null;
            try {
                ((Socket)object2).setSoTimeout(10000);
                ((SSLSocket)object2).startHandshake();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object != null) {
                        try {
                            ((Socket)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Socket)object2).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            DFLog.getLogger(DFCadeiaCertificados.class).error(String.format("[%s] %s", string, exception.toString()));
        }
        if (savingTrustManager.chain != null) {
            DFLog.getLogger(DFCadeiaCertificados.class).debug("Certificados enviados pelo servidor: {}", (Object)savingTrustManager.chain.length);
            object2 = MessageDigest.getInstance("SHA1");
            object = MessageDigest.getInstance("MD5");
            for (int i = 0; i < savingTrustManager.chain.length; ++i) {
                X509Certificate x509Certificate = savingTrustManager.chain[i];
                ((MessageDigest)object2).update(x509Certificate.getEncoded());
                ((MessageDigest)object).update(x509Certificate.getEncoded());
                String string2 = String.format("%s.%s", string, i + 1);
                keyStore.setCertificateEntry(string2, x509Certificate);
                DFLog.getLogger(DFCadeiaCertificados.class).debug("Adicionado certificado no keystore com o alias: {}", (Object)string2);
            }
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager x509TrustManager) {
            this.trustManager = x509TrustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.trustManager.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.chain = x509CertificateArray;
            this.trustManager.checkServerTrusted(x509CertificateArray, string);
        }
    }
}

