/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsulta;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.statusservico.consulta.NfeStatusServico4Stub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final NFeConfig config;

    WSStatusConsulta(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFStatusServicoConsultaRetorno consultaStatus(DFUnidadeFederativa dFUnidadeFederativa, DFModelo dFModelo) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(dFUnidadeFederativa).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsultaStatus(oMElement, dFUnidadeFederativa, dFModelo);
        this.getLogger().debug(oMElement2.toString());
        return (NFStatusServicoConsultaRetorno)this.config.getPersister().read(NFStatusServicoConsultaRetorno.class, oMElement2.toString());
    }

    private NFStatusServicoConsulta gerarDadosConsulta(DFUnidadeFederativa dFUnidadeFederativa) {
        NFStatusServicoConsulta nFStatusServicoConsulta = new NFStatusServicoConsulta();
        nFStatusServicoConsulta.setUf(dFUnidadeFederativa);
        nFStatusServicoConsulta.setAmbiente(this.config.getAmbiente());
        nFStatusServicoConsulta.setVersao(this.config.getVersao());
        nFStatusServicoConsulta.setServico(NOME_SERVICO);
        return nFStatusServicoConsulta;
    }

    private OMElement efetuaConsultaStatus(OMElement oMElement, DFUnidadeFederativa dFUnidadeFederativa, DFModelo dFModelo) throws RemoteException {
        String string;
        NfeStatusServico4Stub.NfeDadosMsg nfeDadosMsg = new NfeStatusServico4Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfCodigoUF(dFUnidadeFederativa);
        String string2 = string = DFModelo.NFCE.equals((Object)dFModelo) ? nFAutorizador400.getNfceStatusServico(this.config.getAmbiente()) : nFAutorizador400.getNfeStatusServico(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico " + dFModelo.name() + ", autorizador " + nFAutorizador400.name() + ", UF " + dFUnidadeFederativa.name());
        }
        return new NfeStatusServico4Stub(string).nfeStatusServicoNF(nfeDadosMsg).getExtraElement();
    }
}

