/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFNotaConsulta;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFNotaConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeConsultaProtocolo4Stub;
import java.math.BigDecimal;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaConsulta
implements DFLog {
    private static final String NOME_SERVICO = "CONSULTAR";
    private static final String VERSAO_SERVICO = "4.00";
    private final NFeConfig config;

    WSNotaConsulta(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFNotaConsultaRetorno consultaNota(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement, string);
        this.getLogger().debug(oMElement2.toString());
        return (NFNotaConsultaRetorno)this.config.getPersister().read(NFNotaConsultaRetorno.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(OMElement oMElement, String string) throws Exception {
        String string2;
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        NFeConsultaProtocolo4Stub.NfeDadosMsg nfeDadosMsg = new NFeConsultaProtocolo4Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfChaveAcesso(string);
        String string3 = string2 = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? nFAutorizador400.getNfceConsultaProtocolo(this.config.getAmbiente()) : nFAutorizador400.getNfeConsultaProtocolo(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para ConsultaProtocolo " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador400.name());
        }
        NFeConsultaProtocolo4Stub.NfeConsultaNFResult nfeConsultaNFResult = new NFeConsultaProtocolo4Stub(string2).nfeConsultaNF(nfeDadosMsg);
        return nfeConsultaNFResult.getExtraElement();
    }

    private NFNotaConsulta gerarDadosConsulta(String string) {
        NFNotaConsulta nFNotaConsulta = new NFNotaConsulta();
        nFNotaConsulta.setAmbiente(this.config.getAmbiente());
        nFNotaConsulta.setChave(string);
        nFNotaConsulta.setServico(NOME_SERVICO);
        nFNotaConsulta.setVersao(new BigDecimal(VERSAO_SERVICO));
        return nFNotaConsulta;
    }
}

