/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFEnviaEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFInfoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFInfoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFProtocoloEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRecepcaoEvento4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

public class WSManifestacaoDestinatario
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private final NFeConfig config;

    public WSManifestacaoDestinatario(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFEnviaEventoRetorno manifestaDestinatarioNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaManifestacaoDestinatario(string2, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    NFEnviaEventoRetorno manifestaDestinatarioNota(String string, NFTipoEventoManifestacaoDestinatario nFTipoEventoManifestacaoDestinatario, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosManifestacaoDestinatario(string, nFTipoEventoManifestacaoDestinatario, string2, string3).toString();
        String string5 = new DFAssinaturaDigital(this.config).assinarDocumento(string4);
        OMElement oMElement = this.efetuaManifestacaoDestinatario(string5, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    NFProtocoloEventoManifestacaoDestinatario manifestaDestinatarioNotaProtocolo(String string, NFTipoEventoManifestacaoDestinatario nFTipoEventoManifestacaoDestinatario, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosManifestacaoDestinatario(string, nFTipoEventoManifestacaoDestinatario, string2, string3).toString();
        String string5 = new DFAssinaturaDigital(this.config).assinarDocumento(string4);
        OMElement oMElement = this.efetuaManifestacaoDestinatario(string5, string);
        NFEnviaEventoManifestacaoDestinatario nFEnviaEventoManifestacaoDestinatario = (NFEnviaEventoManifestacaoDestinatario)this.config.getPersister().read(NFEnviaEventoManifestacaoDestinatario.class, string5);
        NFEnviaEventoRetorno nFEnviaEventoRetorno = (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
        if (nFEnviaEventoRetorno.getCodigoStatusReposta() != 128) {
            throw new RuntimeException("Status: " + nFEnviaEventoRetorno.getCodigoStatusReposta() + " - Motivo: " + nFEnviaEventoRetorno.getMotivo());
        }
        NFProtocoloEventoManifestacaoDestinatario nFProtocoloEventoManifestacaoDestinatario = new NFProtocoloEventoManifestacaoDestinatario();
        nFProtocoloEventoManifestacaoDestinatario.setVersao(nFEnviaEventoManifestacaoDestinatario.getVersao());
        nFProtocoloEventoManifestacaoDestinatario.setEvento(nFEnviaEventoManifestacaoDestinatario.getEvento().get(0));
        nFProtocoloEventoManifestacaoDestinatario.setEventoRetorno(nFEnviaEventoRetorno.getEventoRetorno().get(0));
        return nFProtocoloEventoManifestacaoDestinatario;
    }

    private OMElement efetuaManifestacaoDestinatario(String string, String string2) throws Exception {
        NFeRecepcaoEvento4Stub.NfeDadosMsg nfeDadosMsg = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        nfeDadosMsg.setExtraElement(oMElement);
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string2);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfChaveAcesso(string2);
        String string3 = nFAutorizador400.getRecepcaoEventoAN(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador400.name());
        }
        NFeRecepcaoEvento4Stub.NfeResultMsg nfeResultMsg = new NFeRecepcaoEvento4Stub(string3).nfeRecepcaoEvento(nfeDadosMsg);
        OMElement oMElement2 = nfeResultMsg.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private NFEnviaEventoManifestacaoDestinatario gerarDadosManifestacaoDestinatario(String string, NFTipoEventoManifestacaoDestinatario nFTipoEventoManifestacaoDestinatario, String string2, String string3) {
        NFInfoManifestacaoDestinatario nFInfoManifestacaoDestinatario = new NFInfoManifestacaoDestinatario();
        nFInfoManifestacaoDestinatario.setDescricaoEvento(nFTipoEventoManifestacaoDestinatario.getDescricao());
        nFInfoManifestacaoDestinatario.setVersao(VERSAO_LEIAUTE);
        nFInfoManifestacaoDestinatario.setJustificativa(string2);
        NFInfoEventoManifestacaoDestinatario nFInfoEventoManifestacaoDestinatario = new NFInfoEventoManifestacaoDestinatario();
        nFInfoEventoManifestacaoDestinatario.setAmbiente(this.config.getAmbiente());
        nFInfoEventoManifestacaoDestinatario.setChave(string);
        nFInfoEventoManifestacaoDestinatario.setCnpj(string3);
        nFInfoEventoManifestacaoDestinatario.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        nFInfoEventoManifestacaoDestinatario.setId(String.format("ID%s%s0%s", nFTipoEventoManifestacaoDestinatario.getCodigo(), string, "1"));
        nFInfoEventoManifestacaoDestinatario.setNumeroSequencialEvento(1);
        nFInfoEventoManifestacaoDestinatario.setOrgao(DFUnidadeFederativa.RFB);
        nFInfoEventoManifestacaoDestinatario.setCodigoEvento(nFTipoEventoManifestacaoDestinatario.getCodigo());
        nFInfoEventoManifestacaoDestinatario.setVersaoEvento(VERSAO_LEIAUTE);
        nFInfoEventoManifestacaoDestinatario.setManifestacaoDestinatario(nFInfoManifestacaoDestinatario);
        NFEventoManifestacaoDestinatario nFEventoManifestacaoDestinatario = new NFEventoManifestacaoDestinatario();
        nFEventoManifestacaoDestinatario.setInfoEvento(nFInfoEventoManifestacaoDestinatario);
        nFEventoManifestacaoDestinatario.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoManifestacaoDestinatario nFEnviaEventoManifestacaoDestinatario = new NFEnviaEventoManifestacaoDestinatario();
        nFEnviaEventoManifestacaoDestinatario.setEvento(Collections.singletonList(nFEventoManifestacaoDestinatario));
        nFEnviaEventoManifestacaoDestinatario.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        nFEnviaEventoManifestacaoDestinatario.setVersao(VERSAO_LEIAUTE);
        return nFEnviaEventoManifestacaoDestinatario;
    }
}

