/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFTipoEmissao;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetornoDados;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoSuplementar;
import com.fincatto.documentofiscal.nfe400.utils.NFGeraChave;
import com.fincatto.documentofiscal.nfe400.utils.qrcode20.NFGeraQRCode20;
import com.fincatto.documentofiscal.nfe400.utils.qrcode20.NFGeraQRCodeContingenciaOffline20;
import com.fincatto.documentofiscal.nfe400.utils.qrcode20.NFGeraQRCodeEmissaoNormal20;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeAutorizacao4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.XMLValidador;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang3.StringUtils;

class WSLoteEnvio
implements DFLog {
    private static final String NFE_ELEMENTO = "NFe";
    private final NFeConfig config;

    WSLoteEnvio(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFLoteEnvioRetorno enviaLoteAssinado(String string, DFModelo dFModelo) throws Exception {
        return this.comunicaLote(string, dFModelo);
    }

    NFLoteEnvioRetornoDados enviaLote(NFLoteEnvio nFLoteEnvio) throws Exception {
        NFLoteEnvio nFLoteEnvio2 = this.getLoteAssinado(nFLoteEnvio);
        NFLoteEnvioRetorno nFLoteEnvioRetorno = this.comunicaLote(nFLoteEnvio2.toString(), nFLoteEnvio2.getNotas().get(0).getInfo().getIdentificacao().getModelo());
        return new NFLoteEnvioRetornoDados(nFLoteEnvioRetorno, nFLoteEnvio2);
    }

    NFLoteEnvio getLoteAssinado(NFLoteEnvio nFLoteEnvio) throws Exception {
        for (NFNota dFBase2 : nFLoteEnvio.getNotas()) {
            NFGeraChave n = new NFGeraChave(dFBase2);
            dFBase2.getInfo().getIdentificacao().setCodigoRandomico((String)StringUtils.defaultIfBlank((CharSequence)dFBase2.getInfo().getIdentificacao().getCodigoRandomico(), (CharSequence)n.geraCodigoRandomico()));
            dFBase2.getInfo().getIdentificacao().setDigitoVerificador(n.getDV());
            dFBase2.getInfo().setIdentificador(n.getChaveAcesso());
        }
        String string = new DFAssinaturaDigital(this.config).assinarDocumento(nFLoteEnvio.toString());
        NFLoteEnvio nFLoteEnvio2 = (NFLoteEnvio)this.config.getPersister().read(NFLoteEnvio.class, string);
        int n = 0;
        int n2 = 0;
        block5: for (NFNota nFNota : nFLoteEnvio2.getNotas()) {
            switch (nFNota.getInfo().getIdentificacao().getModelo()) {
                case NFE: {
                    ++n;
                    continue block5;
                }
                case NFCE: {
                    NFGeraQRCode20 nFGeraQRCode20 = this.getNfGeraQRCode20(nFNota);
                    nFNota.setInfoSuplementar(new NFNotaInfoSuplementar());
                    nFNota.getInfoSuplementar().setUrlConsultaChaveAcesso(nFGeraQRCode20.urlConsultaChaveAcesso());
                    nFNota.getInfoSuplementar().setQrCode(nFGeraQRCode20.getQRCode());
                    ++n2;
                    continue block5;
                }
            }
            throw new IllegalArgumentException(String.format("Modelo de nota desconhecida: %s", new Object[]{nFNota.getInfo().getIdentificacao().getModelo()}));
        }
        if (n > 0 && n2 > 0) {
            throw new IllegalArgumentException("Lote contendo notas de modelos diferentes!");
        }
        return nFLoteEnvio2;
    }

    private NFGeraQRCode20 getNfGeraQRCode20(NFNota nFNota) {
        if (NFTipoEmissao.EMISSAO_NORMAL.equals((Object)nFNota.getInfo().getIdentificacao().getTipoEmissao())) {
            return new NFGeraQRCodeEmissaoNormal20(nFNota, this.config);
        }
        if (NFTipoEmissao.CONTIGENCIA_OFFLINE.equals((Object)nFNota.getInfo().getIdentificacao().getTipoEmissao())) {
            return new NFGeraQRCodeContingenciaOffline20(nFNota, this.config);
        }
        throw new IllegalArgumentException("QRCode 2.0 Tipo Emissao nao implementado: " + nFNota.getInfo().getIdentificacao().getTipoEmissao().getDescricao());
    }

    private NFLoteEnvioRetorno comunicaLote(String string, DFModelo dFModelo) throws Exception {
        String string2;
        XMLValidador.validaLote400(string);
        OMElement oMElement = this.nfeToOMElement(string);
        NFeAutorizacao4Stub.NfeDadosMsg nfeDadosMsg = new NFeAutorizacao4Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string3 = string2 = DFModelo.NFE.equals((Object)dFModelo) ? nFAutorizador400.getNfeAutorizacao(this.config.getAmbiente()) : nFAutorizador400.getNfceAutorizacao(this.config.getAmbiente());
        if (string2 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para Autorizacao " + dFModelo.name() + ", autorizador " + nFAutorizador400.name());
        }
        NFeAutorizacao4Stub.NfeResultMsg nfeResultMsg = new NFeAutorizacao4Stub(string2).nfeAutorizacaoLote(nfeDadosMsg);
        NFLoteEnvioRetorno nFLoteEnvioRetorno = (NFLoteEnvioRetorno)this.config.getPersister().read(NFLoteEnvioRetorno.class, nfeResultMsg.getExtraElement().toString());
        this.getLogger().debug(nFLoteEnvioRetorno.toString());
        return nFLoteEnvioRetorno;
    }

    private OMElement nfeToOMElement(String string) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(new StringReader(string));
        StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xMLStreamReader);
        OMElement oMElement = stAXOMBuilder.getDocumentElement();
        Iterator iterator = oMElement.getChildrenWithLocalName(NFE_ELEMENTO);
        while (iterator.hasNext()) {
            OMElement oMElement2 = (OMElement)iterator.next();
            if (oMElement2 == null || !NFE_ELEMENTO.equals(oMElement2.getLocalName())) continue;
            oMElement2.addAttribute("xmlns", "http://www.portalfiscal.inf.br/nfe", null);
        }
        return oMElement;
    }
}

