/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.CadConsultaCadastro2Stub;
import com.fincatto.documentofiscal.nfe400.classes.NFAutorizador400;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFInfoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.webservices.consultacadastro.CadConsultaCadastro4Stub;
import java.util.Arrays;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSConsultaCadastro
implements DFLog {
    private static final String NOME_SERVICO = "CONS-CAD";
    private static final String VERSAO_SERVICO = "2.00";
    private final NFeConfig config;

    WSConsultaCadastro(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFRetornoConsultaCadastro consultaCadastro(String string, DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        NFConsultaCadastro nFConsultaCadastro = this.getDadosConsulta(string, dFUnidadeFederativa);
        String string2 = nFConsultaCadastro.toString();
        this.getLogger().debug(string2);
        OMElement oMElement = AXIOMUtil.stringToOM((String)string2);
        OMElement oMElement2 = this.efetuaConsulta(dFUnidadeFederativa, oMElement);
        this.getLogger().debug(oMElement2.toString());
        return (NFRetornoConsultaCadastro)this.config.getPersister().read(NFRetornoConsultaCadastro.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(DFUnidadeFederativa dFUnidadeFederativa, OMElement oMElement) throws Exception {
        NFAutorizador400 nFAutorizador400 = NFAutorizador400.valueOfCodigoUF(dFUnidadeFederativa);
        if (nFAutorizador400 == null) {
            throw new IllegalStateException(String.format("UF %s nao possui autorizador para este servico", dFUnidadeFederativa.getDescricao()));
        }
        String string = nFAutorizador400.getConsultaCadastro(this.config.getAmbiente());
        if (Arrays.asList(DFUnidadeFederativa.AM, DFUnidadeFederativa.MG, DFUnidadeFederativa.PE).contains((Object)dFUnidadeFederativa)) {
            CadConsultaCadastro2Stub.NfeCabecMsg nfeCabecMsg = new CadConsultaCadastro2Stub.NfeCabecMsg();
            nfeCabecMsg.setCUF(dFUnidadeFederativa.getCodigoIbge());
            nfeCabecMsg.setVersaoDados(VERSAO_SERVICO);
            CadConsultaCadastro2Stub.NfeCabecMsgE nfeCabecMsgE = new CadConsultaCadastro2Stub.NfeCabecMsgE();
            nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
            CadConsultaCadastro2Stub.NfeDadosMsg nfeDadosMsg = new CadConsultaCadastro2Stub.NfeDadosMsg();
            nfeDadosMsg.setExtraElement(oMElement);
            return new CadConsultaCadastro2Stub(string).consultaCadastro2(nfeDadosMsg, nfeCabecMsgE).getExtraElement();
        }
        CadConsultaCadastro4Stub.NfeDadosMsg nfeDadosMsg = new CadConsultaCadastro4Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        return new CadConsultaCadastro4Stub(string).consultaCadastro(nfeDadosMsg).getExtraElement();
    }

    private NFConsultaCadastro getDadosConsulta(String string, DFUnidadeFederativa dFUnidadeFederativa) {
        NFConsultaCadastro nFConsultaCadastro = new NFConsultaCadastro();
        nFConsultaCadastro.setVersao(VERSAO_SERVICO);
        nFConsultaCadastro.setConsultaCadastro(new NFInfoConsultaCadastro());
        nFConsultaCadastro.getConsultaCadastro().setCnpj(string);
        nFConsultaCadastro.getConsultaCadastro().setServico(NOME_SERVICO);
        nFConsultaCadastro.getConsultaCadastro().setUf(dFUnidadeFederativa.getCodigo());
        return nFConsultaCadastro;
    }
}

