/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class NFGeraQRCode {
    private final NFNota nota;
    private final NFeConfig config;

    public NFGeraQRCode(NFNota nFNota, NFeConfig nFeConfig) {
        this.nota = nFNota;
        this.config = nFeConfig;
    }

    public String getQRCodev2() throws NoSuchAlgorithmException {
        String string;
        String string2 = string = this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getQrCodeProducao() : this.nota.getInfo().getIdentificacao().getUf().getQrCodeHomologacao();
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("URL para consulta do QRCode nao informada para uf " + (Object)((Object)this.nota.getInfo().getIdentificacao().getUf()) + "!");
        }
        if (StringUtils.isBlank((CharSequence)this.config.getCodigoSegurancaContribuinte())) {
            throw new IllegalArgumentException("CSC nao informado nas configuracoes!");
        }
        if (this.config.getCodigoSegurancaContribuinteID() == null || this.config.getCodigoSegurancaContribuinteID() == 0) {
            throw new IllegalArgumentException("IdCSC nao informado nas configuracoes!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.nota.getInfo().getChaveAcesso()).append("|");
        stringBuilder.append("2").append("|");
        stringBuilder.append(this.config.getAmbiente().getCodigo()).append("|");
        stringBuilder.append(this.config.getCodigoSegurancaContribuinteID());
        return string.concat("?p=").concat(stringBuilder.toString().concat("|").concat(StringUtils.upperCase((String)NFGeraQRCode.createHash(stringBuilder.toString(), this.config.getCodigoSegurancaContribuinte()))));
    }

    public String getQRCode() throws NoSuchAlgorithmException {
        String string;
        String string2 = string = this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getQrCodeProducao() : this.nota.getInfo().getIdentificacao().getUf().getQrCodeHomologacao();
        if (this.nota.getInfo().getIdentificacao().getUf().equals((Object)DFUnidadeFederativa.PR) && this.nota.getInfo().getVersao().equals("4.00")) {
            string = "http://www.fazenda.pr.gov.br/nfce/qrcode";
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("URL para consulta do QRCode nao informada para uf " + (Object)((Object)this.nota.getInfo().getIdentificacao().getUf()) + "!");
        }
        if (StringUtils.isBlank((CharSequence)this.config.getCodigoSegurancaContribuinte())) {
            throw new IllegalArgumentException("CSC nao informado nas configuracoes!");
        }
        if (this.config.getCodigoSegurancaContribuinteID() == null || this.config.getCodigoSegurancaContribuinteID() == 0) {
            throw new IllegalArgumentException("IdCSC nao informado nas configuracoes!");
        }
        ZonedDateTime zonedDateTime = this.nota.getInfo().getIdentificacao().getDataHoraEmissao();
        String string3 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX").format(zonedDateTime);
        String string4 = this.nota.getInfo().getDestinatario() == null ? null : this.nota.getInfo().getDestinatario().getCpfj();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("chNFe=").append(this.nota.getInfo().getChaveAcesso()).append("&");
        stringBuilder.append("nVersao=100").append("&");
        stringBuilder.append("tpAmb=").append(this.config.getAmbiente().getCodigo()).append("&");
        if (StringUtils.isNotBlank((CharSequence)string4)) {
            stringBuilder.append("cDest=").append(string4).append("&");
        }
        stringBuilder.append("dhEmi=").append(NFGeraQRCode.toHex(string3)).append("&");
        stringBuilder.append("vNF=").append(this.nota.getInfo().getTotal().getIcmsTotal().getValorTotalNFe()).append("&");
        stringBuilder.append("vICMS=").append(this.nota.getInfo().getTotal().getIcmsTotal().getValorTotalICMS()).append("&");
        stringBuilder.append("digVal=").append(NFGeraQRCode.toHex(this.nota.getAssinatura().getSignedInfo().getReference().getDigestValue())).append("&");
        stringBuilder.append("cIdToken=").append(String.format("%06d", this.config.getCodigoSegurancaContribuinteID()));
        return string + "?" + stringBuilder.toString() + "&cHashQRCode=" + NFGeraQRCode.createHash(stringBuilder.toString(), this.config.getCodigoSegurancaContribuinte());
    }

    public static String createHash(String string, String string2) throws NoSuchAlgorithmException {
        return NFGeraQRCode.sha1(string + string2);
    }

    public static String toHex(String string) {
        return String.format("%040x", new BigInteger(1, string.getBytes(Charset.forName("UTF-8"))));
    }

    public static String sha1(String string) throws NoSuchAlgorithmException {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : MessageDigest.getInstance("SHA1").digest(string.getBytes(Charset.forName("UTF-8")))) {
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder.toString();
    }

    public String urlConsultaChaveAcesso() {
        return this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoProducao() : this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoHomologacao();
    }
}

