/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoLacre;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.ListValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoVolume
extends DFBase {
    private static final long serialVersionUID = -7649649556872297786L;
    @Element(name="qVol", required=false)
    private BigInteger quantidadeVolumesTransportados;
    @Element(name="esp", required=false)
    private String especieVolumesTransportados;
    @Element(name="marca", required=false)
    private String marca;
    @Element(name="nVol", required=false)
    private String numeracaoVolumesTransportados;
    @Element(name="pesoL", required=false)
    private String pesoLiquido;
    @Element(name="pesoB", required=false)
    private String pesoBruto;
    @ElementList(entry="lacres", inline=true, required=false)
    private List<NFNotaInfoLacre> lacres;

    public void setQuantidadeVolumesTransportados(BigInteger bigInteger) {
        this.quantidadeVolumesTransportados = bigInteger;
    }

    public void setNumeracaoVolumesTransportados(String string) {
        StringValidador.tamanho60(string, "Numeracao Volumes Transportados");
        this.numeracaoVolumesTransportados = string;
    }

    public void setEspecieVolumesTransportados(String string) {
        StringValidador.tamanho60(string, "Especie Volumes Transportados");
        this.especieVolumesTransportados = string;
    }

    public void setMarca(String string) {
        StringValidador.tamanho60(string, "Marca Volume");
        this.marca = string;
    }

    public void setPesoLiquido(BigDecimal bigDecimal) {
        this.pesoLiquido = BigDecimalValidador.tamanho15Com3CasasDecimais(bigDecimal, "Peso Liquido Volume");
    }

    public void setPesoBruto(BigDecimal bigDecimal) {
        this.pesoBruto = BigDecimalValidador.tamanho15Com3CasasDecimais(bigDecimal, "Peso Bruto Volume");
    }

    public void setLacres(List<NFNotaInfoLacre> list) {
        ListValidador.tamanho5000(list, "Lacres");
        this.lacres = list;
    }

    public BigInteger getQuantidadeVolumesTransportados() {
        return this.quantidadeVolumesTransportados;
    }

    public String getEspecieVolumesTransportados() {
        return this.especieVolumesTransportados;
    }

    public String getMarca() {
        return this.marca;
    }

    public String getNumeracaoVolumesTransportados() {
        return this.numeracaoVolumesTransportados;
    }

    public String getPesoLiquido() {
        return this.pesoLiquido;
    }

    public String getPesoBruto() {
        return this.pesoBruto;
    }

    public List<NFNotaInfoLacre> getLacres() {
        return this.lacres;
    }
}

