/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivelCIDE;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivelEncerrante;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoCombustivel
extends DFBase {
    private static final long serialVersionUID = -2899516480924530882L;
    @Element(name="cProdANP")
    private String codigoProdutoANP = null;
    @Element(name="descANP")
    private String descricaoProdutoANP;
    @Element(name="pGLP", required=false)
    private String percentualGLPDerivadoPetroleo;
    @Element(name="pGNn", required=false)
    private String percentualGasNaturalNacional;
    @Element(name="pGNi", required=false)
    private String percentualGasNaturalImportado;
    @Element(name="vPart", required=false)
    private String valorPartida;
    @Element(name="CODIF", required=false)
    private String codigoAutorizacaoCOFIF = null;
    @Element(name="qTemp", required=false)
    private String quantidade = null;
    @Element(name="UFCons")
    private String uf = null;
    @Element(name="CIDE", required=false)
    private NFNotaInfoItemProdutoCombustivelCIDE cide = null;
    @Element(name="encerrante", required=false)
    private NFNotaInfoItemProdutoCombustivelEncerrante encerrante = null;

    public void setCodigoProdutoANP(String string) {
        StringValidador.exatamente9(string, "Codigo Produto ANP Combustivel");
        this.codigoProdutoANP = string;
    }

    public void setDescricaoProdutoANP(String string) {
        StringValidador.tamanho2a95(string, "Descricao Produto ANP Combustivel");
        this.descricaoProdutoANP = string;
    }

    public void setPercentualGLPDerivadoPetroleo(BigDecimal bigDecimal) {
        this.percentualGLPDerivadoPetroleo = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual GLP derivado petr\u00f3leo");
    }

    public void setPercentualGasNaturalImportado(BigDecimal bigDecimal) {
        this.percentualGasNaturalImportado = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual gas natural importado");
    }

    public void setPercentualGasNaturalNacional(BigDecimal bigDecimal) {
        this.percentualGasNaturalNacional = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual gas natural nacional");
    }

    public void setValorPartida(BigDecimal bigDecimal) {
        this.valorPartida = BigDecimalValidador.tamanho13Com2CasasDecimais(bigDecimal, "Valor de partida");
    }

    public void setCodigoAutorizacaoCODIF(String string) {
        StringValidador.tamanho21(string, "Codigo Autorizacao CODIF Combustivel");
        this.codigoAutorizacaoCOFIF = string;
    }

    public void setQuantidade(BigDecimal bigDecimal) {
        this.quantidade = BigDecimalValidador.tamanho16Com4CasasDecimais(bigDecimal, "Quantidade Combustivel");
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public void setCide(NFNotaInfoItemProdutoCombustivelCIDE nFNotaInfoItemProdutoCombustivelCIDE) {
        this.cide = nFNotaInfoItemProdutoCombustivelCIDE;
    }

    public void setEncerrante(NFNotaInfoItemProdutoCombustivelEncerrante nFNotaInfoItemProdutoCombustivelEncerrante) {
        this.encerrante = nFNotaInfoItemProdutoCombustivelEncerrante;
    }

    public String getCodigoProdutoANP() {
        return this.codigoProdutoANP;
    }

    public String getDescricaoProdutoANP() {
        return this.descricaoProdutoANP;
    }

    public String getPercentualGasNaturalImportado() {
        return this.percentualGasNaturalImportado;
    }

    public String getPercentualGasNaturalNacional() {
        return this.percentualGasNaturalNacional;
    }

    public String getPercentualGLPDerivadoPetroleo() {
        return this.percentualGLPDerivadoPetroleo;
    }

    public String getValorPartida() {
        return this.valorPartida;
    }

    public String getCodigoAutorizacaoCOFIF() {
        return this.codigoAutorizacaoCOFIF;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public String getUf() {
        return this.uf;
    }

    public NFNotaInfoItemProdutoCombustivelCIDE getCide() {
        return this.cide;
    }

    public NFNotaInfoItemProdutoCombustivelEncerrante getEncerrante() {
        return this.encerrante;
    }
}

