/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFProdutoCompoeValorNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorEscalaRelevante;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemDetalheExportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoArmamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivel;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoDeclaracaoImportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoMedicamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoRastreabilidade;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoVeiculo;
import com.fincatto.documentofiscal.nfe400.converters.NFStringNullToEmptyConverter;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.IntegerValidador;
import com.fincatto.documentofiscal.validadores.ListValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.convert.Convert;

public class NFNotaInfoItemProduto
extends DFBase {
    private static final long serialVersionUID = -2271625077897052364L;
    @Element(name="cProd")
    private String codigo;
    @Element(name="cEAN", required=false)
    @Convert(value=NFStringNullToEmptyConverter.class)
    private String codigoDeBarras;
    @Element(name="xProd")
    private String descricao;
    @Element(name="NCM")
    private String ncm;
    @ElementList(entry="NVE", inline=true, required=false)
    private List<String> nomeclaturaValorAduaneiroEstatistica;
    @Element(name="CEST", required=false)
    private String codigoEspecificadorSituacaoTributaria;
    @Element(name="indEscala", required=false)
    private NFIndicadorEscalaRelevante indicadorEscalaRelevante;
    @Element(name="CNPJFab", required=false)
    private String cnpjFabricanteMercadoria;
    @Element(name="cBenef", required=false)
    private String codigoBeneficioFiscalUF;
    @Element(name="EXTIPI", required=false)
    private String extipi;
    @Element(name="CFOP")
    private String cfop;
    @Element(name="uCom")
    private String unidadeComercial;
    @Element(name="qCom")
    private String quantidadeComercial;
    @Element(name="vUnCom")
    private String valorUnitario;
    @Element(name="vProd")
    private String valorTotalBruto;
    @Element(name="cEANTrib", required=false)
    @Convert(value=NFStringNullToEmptyConverter.class)
    private String codigoDeBarrasTributavel;
    @Element(name="uTrib")
    private String unidadeTributavel;
    @Element(name="qTrib")
    private String quantidadeTributavel;
    @Element(name="vUnTrib")
    private String valorUnitarioTributavel;
    @Element(name="vFrete", required=false)
    private String valorFrete;
    @Element(name="vSeg", required=false)
    private String valorSeguro;
    @Element(name="vDesc", required=false)
    private String valorDesconto;
    @Element(name="vOutro", required=false)
    private String valorOutrasDespesasAcessorias;
    @Element(name="indTot")
    private NFProdutoCompoeValorNota compoeValorNota;
    @ElementList(entry="DI", inline=true, required=false)
    private List<NFNotaInfoItemProdutoDeclaracaoImportacao> declaracoesImportacao;
    @ElementList(entry="detExport", inline=true, required=false)
    private List<NFNotaInfoItemDetalheExportacao> detalhesExportacao;
    @Element(name="xPed", required=false)
    private String numeroPedidoCliente;
    @Element(name="nItemPed", required=false)
    private Integer numeroPedidoItemCliente;
    @Element(name="nFCI", required=false)
    private String numeroControleFCI;
    @ElementList(entry="rastro", inline=true, required=false)
    private List<NFNotaInfoItemProdutoRastreabilidade> rastros;
    @Element(name="veicProd", required=false)
    private NFNotaInfoItemProdutoVeiculo veiculo;
    @Element(name="med", required=false)
    private NFNotaInfoItemProdutoMedicamento medicamento;
    @ElementList(entry="arma", inline=true, required=false)
    private List<NFNotaInfoItemProdutoArmamento> armamentos;
    @Element(name="comb", required=false)
    private NFNotaInfoItemProdutoCombustivel combustivel;
    @Element(name="nRECOPI", required=false)
    private String numeroRECOPI;

    public void setCodigo(String string) {
        StringValidador.tamanho60(string, "Codigo Produto");
        this.codigo = string;
    }

    public void setCodigoDeBarras(String string) {
        StringValidador.codigoDeBarras(string);
        this.codigoDeBarras = string;
    }

    public void setDescricao(String string) {
        StringValidador.tamanho120(string, "Descricao Produto");
        this.descricao = string;
    }

    public void setNcm(String string) {
        StringValidador.ncm(string);
        this.ncm = string;
    }

    public void setExtipi(String string) {
        StringValidador.tamanho2ou3N(string, "EX TIPI Produto");
        this.extipi = string;
    }

    public void setCfop(String string) {
        StringValidador.exatamente4N(string, "CFOP Produto");
        this.cfop = string;
    }

    public void setUnidadeComercial(String string) {
        StringValidador.tamanho6(string, "Unidade Comercial Produto");
        this.unidadeComercial = string;
    }

    public void setQuantidadeComercial(BigDecimal bigDecimal) {
        this.quantidadeComercial = BigDecimalValidador.tamanho15comAte4CasasDecimais(bigDecimal, "Qtde Comercial Produto");
    }

    public void setValorUnitario(BigDecimal bigDecimal) {
        this.valorUnitario = BigDecimalValidador.tamanho21ComAte10CasasDecimais(bigDecimal, "Valor Unitario Produto");
    }

    public void setValorTotalBruto(BigDecimal bigDecimal) {
        this.valorTotalBruto = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Bruto Produto");
    }

    public void setCodigoDeBarrasTributavel(String string) {
        StringValidador.codigoDeBarras(string);
        this.codigoDeBarrasTributavel = string;
    }

    public void setUnidadeTributavel(String string) {
        StringValidador.tamanho6(string, "Unidade Tributavel Produto");
        this.unidadeTributavel = string;
    }

    public void setQuantidadeTributavel(BigDecimal bigDecimal) {
        this.quantidadeTributavel = BigDecimalValidador.tamanho15comAte4CasasDecimais(bigDecimal, "Qtde Tributavel Produto");
    }

    public void setValorUnitarioTributavel(BigDecimal bigDecimal) {
        this.valorUnitarioTributavel = BigDecimalValidador.tamanho21ComAte10CasasDecimais(bigDecimal, "Valor Unitario Tributavel Produto");
    }

    public void setValorFrete(BigDecimal bigDecimal) {
        this.valorFrete = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Frete Produto");
    }

    public void setValorSeguro(BigDecimal bigDecimal) {
        this.valorSeguro = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Seguro Produto");
    }

    public void setValorDesconto(BigDecimal bigDecimal) {
        this.valorDesconto = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Desconto Produto");
    }

    public void setValorOutrasDespesasAcessorias(BigDecimal bigDecimal) {
        this.valorOutrasDespesasAcessorias = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Outras Despesas Acessorias Produto");
    }

    public void setCompoeValorNota(NFProdutoCompoeValorNota nFProdutoCompoeValorNota) {
        this.compoeValorNota = nFProdutoCompoeValorNota;
    }

    public void setDeclaracoesImportacao(List<NFNotaInfoItemProdutoDeclaracaoImportacao> list) {
        this.declaracoesImportacao = list;
    }

    public void setNumeroPedidoCliente(String string) {
        StringValidador.tamanho15(string, "Numero Pedido Cliente Produto");
        this.numeroPedidoCliente = string;
    }

    public void setNumeroPedidoItemCliente(Integer n) {
        IntegerValidador.tamanho6(n, "Numero Pedido Item Cliente Produto");
        this.numeroPedidoItemCliente = n;
    }

    public void setNumeroControleFCI(String string) {
        StringValidador.fci(string);
        this.numeroControleFCI = string;
    }

    public void setVeiculo(NFNotaInfoItemProdutoVeiculo nFNotaInfoItemProdutoVeiculo) {
        if (this.medicamento != null || this.armamentos != null || this.combustivel != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos e combustivel sao mutuamente exclusivos");
        }
        this.veiculo = nFNotaInfoItemProdutoVeiculo;
    }

    public void setMedicamento(NFNotaInfoItemProdutoMedicamento nFNotaInfoItemProdutoMedicamento) {
        if (this.veiculo != null || this.armamentos != null || this.combustivel != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        this.medicamento = nFNotaInfoItemProdutoMedicamento;
    }

    public void setArmamentos(List<NFNotaInfoItemProdutoArmamento> list) {
        if (this.medicamento != null || this.veiculo != null || this.combustivel != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        ListValidador.tamanho500(list, "Armamentos Produto");
        this.armamentos = list;
    }

    public void setCombustivel(NFNotaInfoItemProdutoCombustivel nFNotaInfoItemProdutoCombustivel) {
        if (this.medicamento != null || this.armamentos != null || this.veiculo != null || this.numeroRECOPI != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        this.combustivel = nFNotaInfoItemProdutoCombustivel;
    }

    public void setNomeclaturaValorAduaneiroEstatistica(List<String> list) {
        for (String string : list) {
            StringValidador.nve(string);
        }
        this.nomeclaturaValorAduaneiroEstatistica = list;
    }

    public void setCodigoEspecificadorSituacaoTributaria(String string) {
        StringValidador.exatamente7N(string, "CEST Produto");
        this.codigoEspecificadorSituacaoTributaria = string;
    }

    public void setDetalhesExportacao(List<NFNotaInfoItemDetalheExportacao> list) {
        ListValidador.tamanho500(list, "Detalhes Exportacao Produto");
        this.detalhesExportacao = list;
    }

    public void setNumeroRECOPI(String string) {
        if (this.medicamento != null || this.armamentos != null || this.veiculo != null || this.combustivel != null) {
            throw new IllegalStateException("veiculos, medicamentos, armamentos, RECOPI e combustivel sao mutuamente exclusivos");
        }
        StringValidador.exatamente20N(string, "Numero RECOPI Produto");
        this.numeroRECOPI = string;
    }

    public void setRastros(List<NFNotaInfoItemProdutoRastreabilidade> list) {
        ListValidador.tamanho500(list, "Rastreios do produto");
        this.rastros = list;
    }

    public void setIndicadorEscalaRelevante(NFIndicadorEscalaRelevante nFIndicadorEscalaRelevante) {
        this.indicadorEscalaRelevante = nFIndicadorEscalaRelevante;
    }

    public void setCnpjFabricanteMercadoria(String string) {
        this.cnpjFabricanteMercadoria = string;
    }

    public void setCodigoBeneficioFiscalUF(String string) {
        this.codigoBeneficioFiscalUF = StringValidador.validador(string, "Codigo Beneficio Fiscal da UF", 10, false, false);
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getCodigoDeBarras() {
        return this.codigoDeBarras == null ? "SEM GTIN" : this.codigoDeBarras;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getNcm() {
        return this.ncm;
    }

    public List<String> getNomeclaturaValorAduaneiroEstatistica() {
        return this.nomeclaturaValorAduaneiroEstatistica;
    }

    public String getCodigoEspecificadorSituacaoTributaria() {
        return this.codigoEspecificadorSituacaoTributaria;
    }

    public String getExtipi() {
        return this.extipi;
    }

    public String getCfop() {
        return this.cfop;
    }

    public String getUnidadeComercial() {
        return this.unidadeComercial;
    }

    public String getQuantidadeComercial() {
        return this.quantidadeComercial;
    }

    public String getValorUnitario() {
        return this.valorUnitario;
    }

    public String getValorTotalBruto() {
        return this.valorTotalBruto;
    }

    public String getCodigoDeBarrasTributavel() {
        return this.codigoDeBarrasTributavel == null ? "SEM GTIN" : this.codigoDeBarrasTributavel;
    }

    public String getUnidadeTributavel() {
        return this.unidadeTributavel;
    }

    public String getQuantidadeTributavel() {
        return this.quantidadeTributavel;
    }

    public String getValorUnitarioTributavel() {
        return this.valorUnitarioTributavel;
    }

    public String getValorFrete() {
        return this.valorFrete;
    }

    public String getValorSeguro() {
        return this.valorSeguro;
    }

    public String getValorDesconto() {
        return this.valorDesconto;
    }

    public String getValorOutrasDespesasAcessorias() {
        return this.valorOutrasDespesasAcessorias;
    }

    public NFProdutoCompoeValorNota getCompoeValorNota() {
        return this.compoeValorNota;
    }

    public List<NFNotaInfoItemProdutoDeclaracaoImportacao> getDeclaracoesImportacao() {
        return this.declaracoesImportacao;
    }

    public List<NFNotaInfoItemDetalheExportacao> getDetalhesExportacao() {
        return this.detalhesExportacao;
    }

    public String getNumeroPedidoCliente() {
        return this.numeroPedidoCliente;
    }

    public Integer getNumeroPedidoItemCliente() {
        return this.numeroPedidoItemCliente;
    }

    public String getNumeroControleFCI() {
        return this.numeroControleFCI;
    }

    public NFNotaInfoItemProdutoVeiculo getVeiculo() {
        return this.veiculo;
    }

    public NFNotaInfoItemProdutoMedicamento getMedicamento() {
        return this.medicamento;
    }

    public List<NFNotaInfoItemProdutoArmamento> getArmamentos() {
        return this.armamentos;
    }

    public NFNotaInfoItemProdutoCombustivel getCombustivel() {
        return this.combustivel;
    }

    public String getNumeroRECOPI() {
        return this.numeroRECOPI;
    }

    public String getCnpjFabricanteMercadoria() {
        return this.cnpjFabricanteMercadoria;
    }

    public String getCodigoBeneficioFiscalUF() {
        return this.codigoBeneficioFiscalUF;
    }

    public NFIndicadorEscalaRelevante getIndicadorEscalaRelevante() {
        return this.indicadorEscalaRelevante;
    }

    public List<NFNotaInfoItemProdutoRastreabilidade> getRastros() {
        return this.rastros;
    }
}

