/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPINaoTributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPITributado;
import com.fincatto.documentofiscal.validadores.BigIntegerValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigInteger;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoIPI
extends DFBase {
    private static final long serialVersionUID = 3354365738012803301L;
    @Element(name="CNPJProd", required=false)
    private String cnpjProdutor = null;
    @Element(name="cSelo", required=false)
    private String codigoSelo = null;
    @Element(name="qSelo", required=false)
    private BigInteger quantidadeSelo = null;
    @Element(name="cEnq")
    private String codigoEnquadramento = null;
    @Element(name="IPITrib", required=false)
    private NFNotaInfoItemImpostoIPITributado tributado = null;
    @Element(name="IPINT", required=false)
    private NFNotaInfoItemImpostoIPINaoTributado naoTributado = null;

    public void setCnpjProdutor(String string) {
        StringValidador.cnpj(string);
        this.cnpjProdutor = string;
    }

    public void setCodigoSelo(String string) {
        StringValidador.tamanho60(string, "Codigo Selo IPI Item");
        this.codigoSelo = string;
    }

    public void setQuantidadeSelo(BigInteger bigInteger) {
        BigIntegerValidador.tamanho12(bigInteger, "Quantidade Selo IPI Item");
        this.quantidadeSelo = bigInteger;
    }

    public void setCodigoEnquadramento(String string) {
        StringValidador.exatamente3(string, "Codigo Enquadramento IPI Item");
        this.codigoEnquadramento = string;
    }

    public void setTributado(NFNotaInfoItemImpostoIPITributado nFNotaInfoItemImpostoIPITributado) {
        if (this.naoTributado != null) {
            throw new IllegalStateException("IPI tributado e nao tributado sao mutuamente exclusivos");
        }
        this.tributado = nFNotaInfoItemImpostoIPITributado;
    }

    public void setNaoTributado(NFNotaInfoItemImpostoIPINaoTributado nFNotaInfoItemImpostoIPINaoTributado) {
        if (this.tributado != null) {
            throw new IllegalStateException("IPI tributado e nao tributado sao mutuamente exclusivos");
        }
        this.naoTributado = nFNotaInfoItemImpostoIPINaoTributado;
    }

    public String getCnpjProdutor() {
        return this.cnpjProdutor;
    }

    public String getCodigoSelo() {
        return this.codigoSelo;
    }

    public BigInteger getQuantidadeSelo() {
        return this.quantidadeSelo;
    }

    public String getCodigoEnquadramento() {
        return this.codigoEnquadramento;
    }

    public NFNotaInfoItemImpostoIPITributado getTributado() {
        return this.tributado;
    }

    public NFNotaInfoItemImpostoIPINaoTributado getNaoTributado() {
        return this.naoTributado;
    }
}

