/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMSSN900
extends DFBase {
    private static final long serialVersionUID = 4771007345613617306L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CSOSN")
    private NFNotaSituacaoOperacionalSimplesNacional situacaoOperacaoSN;
    @Element(name="modBC", required=false)
    private NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS;
    @Element(name="vBC", required=false)
    private String valorBCICMS;
    @Element(name="pRedBC", required=false)
    private String percentualReducaoBC;
    @Element(name="pICMS", required=false)
    private String percentualAliquotaImposto;
    @Element(name="vICMS", required=false)
    private String valorICMS;
    @Element(name="modBCST", required=false)
    private NFNotaInfoItemModalidadeBCICMSST modalidadeBCICMSST;
    @Element(name="pMVAST", required=false)
    private String percentualMargemValorAdicionadoICMSST;
    @Element(name="pRedBCST", required=false)
    private String percentualReducaoBCICMSST;
    @Element(name="vBCST", required=false)
    private String valorBCICMSST;
    @Element(name="pICMSST", required=false)
    private String percentualAliquotaImpostoICMSST;
    @Element(name="vICMSST", required=false)
    private String valorICMSST;
    @Element(name="vBCFCPST", required=false)
    private String valorBCFundoCombatePobrezaST;
    @Element(name="pFCPST", required=false)
    private String percentualFundoCombatePobrezaST;
    @Element(name="vFCPST", required=false)
    private String valorFundoCombatePobrezaST;
    @Element(name="pCredSN", required=false)
    private String percentualAliquotaAplicavelCalculoCreditoSN;
    @Element(name="vCredICMSSN", required=false)
    private String valorCreditoICMSSN;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional nFNotaSituacaoOperacionalSimplesNacional) {
        this.situacaoOperacaoSN = nFNotaSituacaoOperacionalSimplesNacional;
    }

    public void setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS nFNotaInfoItemModalidadeBCICMS) {
        this.modalidadeBCICMS = nFNotaInfoItemModalidadeBCICMS;
    }

    public void setValorBCICMS(BigDecimal bigDecimal) {
        this.valorBCICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMSSN900");
    }

    public void setPercentualReducaoBC(BigDecimal bigDecimal) {
        this.percentualReducaoBC = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMSSN900");
    }

    public void setPercentualAliquotaImposto(BigDecimal bigDecimal) {
        this.percentualAliquotaImposto = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota Imposto ICMSSN900");
    }

    public void setValorICMS(BigDecimal bigDecimal) {
        this.valorICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMSSN900");
    }

    public void setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST nFNotaInfoItemModalidadeBCICMSST) {
        this.modalidadeBCICMSST = nFNotaInfoItemModalidadeBCICMSST;
    }

    public void setPercentualMargemValorAdicionadoICMSST(BigDecimal bigDecimal) {
        this.percentualMargemValorAdicionadoICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Margel Valor Adicionado ICMS ST ICMSSN900");
    }

    public void setPercentualReducaoBCICMSST(BigDecimal bigDecimal) {
        this.percentualReducaoBCICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS ST ICMSSN900");
    }

    public void setValorBCICMSST(BigDecimal bigDecimal) {
        this.valorBCICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST ICMSSN900");
    }

    public void setPercentualAliquotaImpostoICMSST(BigDecimal bigDecimal) {
        this.percentualAliquotaImpostoICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota Imposto ICMS ST ICMSSN900");
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST ICMSSN900");
    }

    public void setValorBCFundoCombatePobrezaST(BigDecimal bigDecimal) {
        this.valorBCFundoCombatePobrezaST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Base calculo fundo combate pobreza ST");
    }

    public void setPercentualFundoCombatePobrezaST(BigDecimal bigDecimal) {
        if (bigDecimal == null || bigDecimal.signum() <= 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobrezaST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual fundo combate pobreza ST");
    }

    public void setValorFundoCombatePobrezaST(BigDecimal bigDecimal) {
        this.valorFundoCombatePobrezaST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor fundo combate pobreza ST");
    }

    public void setPercentualAliquotaAplicavelCalculoCreditoSN(BigDecimal bigDecimal) {
        this.percentualAliquotaAplicavelCalculoCreditoSN = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota Aplicavel Calculo Credito SN ICMSSN900");
    }

    public void setValorCreditoICMSSN(BigDecimal bigDecimal) {
        this.valorCreditoICMSSN = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Credito ICMSSN900");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaSituacaoOperacionalSimplesNacional getSituacaoOperacaoSN() {
        return this.situacaoOperacaoSN;
    }

    public NFNotaInfoItemModalidadeBCICMS getModalidadeBCICMS() {
        return this.modalidadeBCICMS;
    }

    public String getValorBCICMS() {
        return this.valorBCICMS;
    }

    public String getPercentualReducaoBC() {
        return this.percentualReducaoBC;
    }

    public String getPercentualAliquotaImposto() {
        return this.percentualAliquotaImposto;
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public NFNotaInfoItemModalidadeBCICMSST getModalidadeBCICMSST() {
        return this.modalidadeBCICMSST;
    }

    public String getPercentualMargemValorAdicionadoICMSST() {
        return this.percentualMargemValorAdicionadoICMSST;
    }

    public String getPercentualReducaoBCICMSST() {
        return this.percentualReducaoBCICMSST;
    }

    public String getValorBCICMSST() {
        return this.valorBCICMSST;
    }

    public String getPercentualAliquotaImpostoICMSST() {
        return this.percentualAliquotaImpostoICMSST;
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public String getValorBCFundoCombatePobrezaST() {
        return this.valorBCFundoCombatePobrezaST;
    }

    public String getPercentualFundoCombatePobrezaST() {
        return this.percentualFundoCombatePobrezaST;
    }

    public String getValorFundoCombatePobrezaST() {
        return this.valorFundoCombatePobrezaST;
    }

    public String getPercentualAliquotaAplicavelCalculoCreditoSN() {
        return this.percentualAliquotaAplicavelCalculoCreditoSN;
    }

    public String getValorCreditoICMSSN() {
        return this.valorCreditoICMSSN;
    }
}

