/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMSSN202
extends DFBase {
    private static final long serialVersionUID = -7219850658794969064L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CSOSN")
    private NFNotaSituacaoOperacionalSimplesNacional situacaoOperacaoSN;
    @Element(name="modBCST")
    private NFNotaInfoItemModalidadeBCICMSST modalidadeBCICMSST;
    @Element(name="pMVAST", required=false)
    private String percentualMargemValorAdicionadoICMSST;
    @Element(name="pRedBCST", required=false)
    private String percentualReducaoBCICMSST;
    @Element(name="vBCST")
    private String valorBCICMSST;
    @Element(name="pICMSST")
    private String percentualAliquotaImpostoICMSST;
    @Element(name="vICMSST")
    private String valorICMSST;
    @Element(name="vBCFCPST", required=false)
    private String valorBCFundoCombatePobrezaST;
    @Element(name="pFCPST", required=false)
    private String percentualFundoCombatePobrezaST;
    @Element(name="vFCPST", required=false)
    private String valorFundoCombatePobrezaST;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional nFNotaSituacaoOperacionalSimplesNacional) {
        this.situacaoOperacaoSN = nFNotaSituacaoOperacionalSimplesNacional;
    }

    public void setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST nFNotaInfoItemModalidadeBCICMSST) {
        this.modalidadeBCICMSST = nFNotaInfoItemModalidadeBCICMSST;
    }

    public void setPercentualMargemValorAdicionadoICMSST(BigDecimal bigDecimal) {
        this.percentualMargemValorAdicionadoICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Margem Valor Adicionado ICMS ST ICMSSN202");
    }

    public void setPercentualReducaoBCICMSST(BigDecimal bigDecimal) {
        this.percentualReducaoBCICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMSST ICMSSN202");
    }

    public void setValorBCICMSST(BigDecimal bigDecimal) {
        this.valorBCICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST ICMSSN202");
    }

    public void setPercentualAliquotaImpostoICMSST(BigDecimal bigDecimal) {
        this.percentualAliquotaImpostoICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Aliquota Imposto ICMSST ICMSSN202");
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST ICMSSN202");
    }

    public void setValorBCFundoCombatePobrezaST(BigDecimal bigDecimal) {
        this.valorBCFundoCombatePobrezaST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Base calculo fundo combate pobreza ST");
    }

    public void setPercentualFundoCombatePobrezaST(BigDecimal bigDecimal) {
        if (bigDecimal.signum() <= 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobrezaST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual fundo combate pobreza ST");
    }

    public void setValorFundoCombatePobrezaST(BigDecimal bigDecimal) {
        this.valorFundoCombatePobrezaST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor fundo combate pobreza ST");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaSituacaoOperacionalSimplesNacional getSituacaoOperacaoSN() {
        return this.situacaoOperacaoSN;
    }

    public NFNotaInfoItemModalidadeBCICMSST getModalidadeBCICMSST() {
        return this.modalidadeBCICMSST;
    }

    public String getPercentualMargemValorAdicionadoICMSST() {
        return this.percentualMargemValorAdicionadoICMSST;
    }

    public String getPercentualReducaoBCICMSST() {
        return this.percentualReducaoBCICMSST;
    }

    public String getValorBCICMSST() {
        return this.valorBCICMSST;
    }

    public String getPercentualAliquotaImpostoICMSST() {
        return this.percentualAliquotaImpostoICMSST;
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public String getValorBCFundoCombatePobrezaST() {
        return this.valorBCFundoCombatePobrezaST;
    }

    public String getPercentualFundoCombatePobrezaST() {
        return this.percentualFundoCombatePobrezaST;
    }

    public String getValorFundoCombatePobrezaST() {
        return this.valorFundoCombatePobrezaST;
    }
}

