/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMSPartilhado
extends DFBase {
    private static final long serialVersionUID = 3053815337863231705L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="modBC")
    private NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS;
    @Element(name="vBC")
    private String valorBCICMS;
    @Element(name="pRedBC", required=false)
    private String percentualReducaoBC;
    @Element(name="pICMS")
    private String percentualAliquotaImposto;
    @Element(name="vICMS")
    private String valorICMS;
    @Element(name="modBCST")
    private NFNotaInfoItemModalidadeBCICMSST modalidadeBCICMSST;
    @Element(name="pMVAST", required=false)
    private String percentualMargemValorAdicionadoICMSST;
    @Element(name="pRedBCST", required=false)
    private String percentualReducaoBCICMSST;
    @Element(name="vBCST")
    private String valorBCICMSST;
    @Element(name="pICMSST")
    private String percentualAliquotaImpostoICMSST;
    @Element(name="vICMSST")
    private String valorICMSST;
    @Element(name="pBCOp")
    private String percentualBCOperacaoPropria;
    @Element(name="UFST")
    private String ufICMSST;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS nFNotaInfoItemModalidadeBCICMS) {
        this.modalidadeBCICMS = nFNotaInfoItemModalidadeBCICMS;
    }

    public void setValorBCICMS(BigDecimal bigDecimal) {
        this.valorBCICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS Partilhado");
    }

    public void setPercentualReducaoBC(BigDecimal bigDecimal) {
        this.percentualReducaoBC = BigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS Partilhado");
    }

    public void setPercentualAliquotaImposto(BigDecimal bigDecimal) {
        this.percentualAliquotaImposto = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Aliquota Imposto ICMS Partilhado");
    }

    public void setValorICMS(BigDecimal bigDecimal) {
        this.valorICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Partilhado");
    }

    public void setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST nFNotaInfoItemModalidadeBCICMSST) {
        this.modalidadeBCICMSST = nFNotaInfoItemModalidadeBCICMSST;
    }

    public void setPercentualMargemValorAdicionadoICMSST(BigDecimal bigDecimal) {
        this.percentualMargemValorAdicionadoICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Margem Valor Adicionado ICMS ST Partilhado");
    }

    public void setPercentualReducaoBCICMSST(BigDecimal bigDecimal) {
        this.percentualReducaoBCICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS ST Partilhado");
    }

    public void setValorBCICMSST(BigDecimal bigDecimal) {
        this.valorBCICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ST Partilhado");
    }

    public void setPercentualAliquotaImpostoICMSST(BigDecimal bigDecimal) {
        this.percentualAliquotaImpostoICMSST = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Aliquota Imposto ICMS ST Partilhado");
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ST Partilhado");
    }

    public void setPercentualBCOperacaoPropria(BigDecimal bigDecimal) {
        this.percentualBCOperacaoPropria = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Partilhado");
    }

    public void setUfICMSST(DFUnidadeFederativa dFUnidadeFederativa) {
        this.ufICMSST = dFUnidadeFederativa.getCodigo();
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public NFNotaInfoItemModalidadeBCICMS getModalidadeBCICMS() {
        return this.modalidadeBCICMS;
    }

    public String getValorBCICMS() {
        return this.valorBCICMS;
    }

    public String getPercentualReducaoBC() {
        return this.percentualReducaoBC;
    }

    public String getPercentualAliquotaImposto() {
        return this.percentualAliquotaImposto;
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public NFNotaInfoItemModalidadeBCICMSST getModalidadeBCICMSST() {
        return this.modalidadeBCICMSST;
    }

    public String getPercentualMargemValorAdicionadoICMSST() {
        return this.percentualMargemValorAdicionadoICMSST;
    }

    public String getPercentualReducaoBCICMSST() {
        return this.percentualReducaoBCICMSST;
    }

    public String getValorBCICMSST() {
        return this.valorBCICMSST;
    }

    public String getPercentualAliquotaImpostoICMSST() {
        return this.percentualAliquotaImpostoICMSST;
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public String getPercentualBCOperacaoPropria() {
        return this.percentualBCOperacaoPropria;
    }

    public String getUfICMSST() {
        return this.ufICMSST;
    }
}

