/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoCOFINSQuantidade
extends DFBase {
    private static final long serialVersionUID = -7179547773505825448L;
    @Element(name="CST")
    private NFNotaInfoSituacaoTributariaCOFINS situacaoTributaria = null;
    @Element(name="qBCProd")
    private String quantidadeVendida = null;
    @Element(name="vAliqProd")
    private String valorAliquota = null;
    @Element(name="vCOFINS")
    private String valorTributo = null;

    public void setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS nFNotaInfoSituacaoTributariaCOFINS) {
        if (!NFNotaInfoSituacaoTributariaCOFINS.OPERACAO_TRIBUTAVEL_QUANTIDADE_VENDIDA_POR_ALIQUOTA_POR_UNIDADE_PRODUTO.equals((Object)nFNotaInfoSituacaoTributariaCOFINS)) {
            throw new IllegalStateException("Situacao tributaria invalida no item COFINS quantidade.");
        }
        this.situacaoTributaria = nFNotaInfoSituacaoTributariaCOFINS;
    }

    public void setQuantidadeVendida(BigDecimal bigDecimal) {
        this.quantidadeVendida = BigDecimalValidador.tamanho16ComAte4CasasDecimais(bigDecimal, "Quantidade Vendida COFINS Item Qtde");
    }

    public void setValorAliquota(BigDecimal bigDecimal) {
        this.valorAliquota = BigDecimalValidador.tamanho15Com4CasasDecimais(bigDecimal, "Valor Aliquota COFINS Item Qtde");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo COFINS Item Qtde");
    }

    public NFNotaInfoSituacaoTributariaCOFINS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getQuantidadeVendida() {
        return this.quantidadeVendida;
    }

    public String getValorAliquota() {
        return this.valorAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }
}

