/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoCOFINSOutrasOperacoes
extends DFBase {
    private static final long serialVersionUID = -7291550051334950307L;
    @Element(name="CST")
    private NFNotaInfoSituacaoTributariaCOFINS situacaoTributaria;
    @Element(name="vBC", required=false)
    private String valorBaseCalculo;
    @Element(name="pCOFINS", required=false)
    private String percentualCOFINS;
    @Element(name="qBCProd", required=false)
    private String quantidadeVendida;
    @Element(name="vAliqProd", required=false)
    private String valorAliquota;
    @Element(name="vCOFINS", required=false)
    private String valorCOFINS;

    public void setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS nFNotaInfoSituacaoTributariaCOFINS) {
        this.situacaoTributaria = nFNotaInfoSituacaoTributariaCOFINS;
    }

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        this.valorBaseCalculo = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Base Calculo COFINS OA Item");
    }

    public void setPercentualCOFINS(BigDecimal bigDecimal) {
        this.percentualCOFINS = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual COFINS OA Item");
    }

    public void setQuantidadeVendida(BigDecimal bigDecimal) {
        this.quantidadeVendida = BigDecimalValidador.tamanho16ComAte4CasasDecimais(bigDecimal, "Quantidade Vendida COFINS OA Item");
    }

    public void setValorAliquota(BigDecimal bigDecimal) {
        this.valorAliquota = BigDecimalValidador.tamanho15Com4CasasDecimais(bigDecimal, "Valor Aliquota COFINS OA Item");
    }

    public void setValorCOFINS(BigDecimal bigDecimal) {
        this.valorCOFINS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo COFINS OA Item");
    }

    public NFNotaInfoSituacaoTributariaCOFINS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualCOFINS() {
        return this.percentualCOFINS;
    }

    public String getQuantidadeVendida() {
        return this.quantidadeVendida;
    }

    public String getValorAliquota() {
        return this.valorAliquota;
    }

    public String getValorCOFINS() {
        return this.valorCOFINS;
    }
}

