/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.BigIntegerValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemExportacaoIndireta
extends DFBase {
    private static final long serialVersionUID = 2911935204123851926L;
    @Element(name="nRE")
    private BigInteger numeroRegistroExportacao;
    @Element(name="chNFe")
    private String chaveAcessoNFe;
    @Element(name="qExport")
    private String quantidadeItemEfetivamenteExportado;

    public void setChaveAcessoNFe(String string) {
        StringValidador.exatamente44N(string, "Chave de Acesso NFe");
        this.chaveAcessoNFe = string;
    }

    public void setNumeroRegistroExportacao(BigInteger bigInteger) {
        BigIntegerValidador.tamanho12(bigInteger, "Numero Registro Exportacao");
        this.numeroRegistroExportacao = bigInteger;
    }

    public void setQuantidadeItemEfetivamenteExportado(BigDecimal bigDecimal) {
        this.quantidadeItemEfetivamenteExportado = BigDecimalValidador.tamanho15comAte4CasasDecimais(bigDecimal, "Quantidade Item Evetivamente Exportado");
    }

    public String getChaveAcessoNFe() {
        return this.chaveAcessoNFe;
    }

    public BigInteger getNumeroRegistroExportacao() {
        return this.numeroRegistroExportacao;
    }

    public String getQuantidadeItemEfetivamenteExportado() {
        return this.quantidadeItemEfetivamenteExportado;
    }
}

