/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.IntegerValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;

public class NFInfoModelo1Por1AReferenciada
extends DFBase {
    private static final long serialVersionUID = 4441065943167631316L;
    @Element(name="cUF")
    private DFUnidadeFederativa uf;
    @Element(name="AAMM")
    private String anoMesEmissaoNFe;
    @Element(name="CNPJ")
    private String cnpj;
    @Element(name="mod")
    private String modeloDocumentoFiscal;
    @Element(name="serie")
    private Integer serie;
    @Element(name="nNF", required=false)
    private String numeroDocumentoFiscal;

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa;
    }

    public void setAnoMesEmissaoNFe(String string) {
        StringValidador.aamm(string);
        this.anoMesEmissaoNFe = string;
    }

    public void setCnpj(String string) {
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public void setModeloDocumentoFiscal(String string) {
        StringValidador.exatamente2(string, "Modelo Documento Fiscal");
        this.modeloDocumentoFiscal = string;
    }

    public void setSerie(Integer n) {
        IntegerValidador.tamanho3(n, "Serie");
        this.serie = n;
    }

    public void setNumeroDocumentoFiscal(String string) {
        StringValidador.tamanho9(string, "Numero Documento Fiscal");
        this.numeroDocumentoFiscal = string;
    }

    public DFUnidadeFederativa getUf() {
        return this.uf;
    }

    public String getAnoMesEmissaoNFe() {
        return this.anoMesEmissaoNFe;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getModeloDocumentoFiscal() {
        return this.modeloDocumentoFiscal;
    }

    public Integer getSerie() {
        return this.serie;
    }

    public String getNumeroDocumentoFiscal() {
        return this.numeroDocumentoFiscal;
    }
}

