/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.IntegerValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="infInut")
public class NFEventoInutilizacaoDados
extends DFBase {
    private static final long serialVersionUID = -5481681546706524562L;
    @Attribute(name="Id")
    private String identificador;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="xServ")
    private String nomeServico;
    @Element(name="cUF")
    private DFUnidadeFederativa uf;
    @Element(name="ano")
    private Integer ano;
    @Element(name="CNPJ")
    private String cnpj;
    @Element(name="mod")
    private String modeloDocumentoFiscal;
    @Element(name="serie")
    private String serie;
    @Element(name="nNFIni")
    private String numeroNFInicial;
    @Element(name="nNFFin")
    private String numeroNFFinal;
    @Element(name="xJust")
    private String justificativa;

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String string) {
        StringValidador.identificador(string);
        this.identificador = string;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getNomeServico() {
        return this.nomeServico;
    }

    public void setNomeServico(String string) {
        if (!string.equals("INUTILIZAR")) {
            throw new IllegalStateException("Nome de servico invalido");
        }
        this.nomeServico = string;
    }

    public DFUnidadeFederativa getUf() {
        return this.uf;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa;
    }

    public int getAno() {
        return this.ano;
    }

    public void setAno(Integer n) {
        IntegerValidador.exatamente2(n, "Ano");
        this.ano = n;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getModeloDocumentoFiscal() {
        return this.modeloDocumentoFiscal;
    }

    public void setModeloDocumentoFiscal(String string) {
        StringValidador.modeloDocumentoFiscal(string);
        this.modeloDocumentoFiscal = string;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String string) {
        StringValidador.tamanho3N(string, "Serie");
        this.serie = string;
    }

    public String getNumeroNFInicial() {
        return this.numeroNFInicial;
    }

    public void setNumeroNFInicial(String string) {
        StringValidador.tamanho9N(string, "Numero NF Inicial");
        this.numeroNFInicial = string;
    }

    public String getNumeroNFFinal() {
        return this.numeroNFFinal;
    }

    public void setNumeroNFFinal(String string) {
        StringValidador.tamanho9N(string, "Numero NF Final");
        this.numeroNFFinal = string;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String string) {
        StringValidador.tamanho15a255(string, "Justificativa");
        this.justificativa = string;
    }
}

